﻿/**
 * ...
 * @author Anna-Liisa Mattila
 */

(function() {
	var RandomEffect = function(main, renderCacheAmount, partId){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
	}
	var p = RandomEffect.prototype = new wideload.BasePart();
	wideload.RandomEffect = RandomEffect;
	
	p.superInitialize = p.initialize;
	p.initialize = function(renderer){
		this.superInitialize(renderer);
    
		this.maxX = this.main.resolution.width/2;
		this.minX = -this.main.resolution.width/2;
		this.maxY = this.main.resolution.height/2;
		this.minY = -this.main.resolution.height/2;
		
		this.camera = new THREE.OrthographicCamera(this.minX,this.maxX, this.maxY, this.minY);
		
		this.shaderMaterial = new THREE.ShaderMaterial({
			uniforms: wideload.RandomShader.uniforms,
			attributes: wideload.RandomShader.attributes,
			vertexShader: wideload.RandomShader.vertex,
			fragmentShader: wideload.RandomShader.fragment,
			color: "white"
		});
		
		//var planeGeom = new THREE.PlaneGeometry(this.main.resolution.width, this.main.resolution.height);
		var planeGeom = new THREE.PlaneGeometry(1280, 720);
		var plane = new THREE.Mesh(planeGeom, this.shaderMaterial);
		this.scene.add(plane);
		
		this.camera.position.z = 1;
		
		this.isActive = true;
	}
	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){
		
		//this.shaderMaterial.uniforms.resolution.value.x = $("#demo canvas").width()/1;
		//this.shaderMaterial.uniforms.resolution.value.y = $("#demo canvas").height()/1;
		this.shaderMaterial.uniforms.resolution.value.x = 1280;// this.main.resolution.width;// $("#demo canvas").width()/1;
		this.shaderMaterial.uniforms.resolution.value.y = 720;//this.main.resolution.height;//$("#demo canvas").height()/1;
		
		this.shaderMaterial.uniforms.time.value = elapsedtime/5000;
    
		this.renderer.render(this.scene, this.camera, renderTarget);
	}
	
	
})();