﻿/**
 * ...
 * @author Anna-Liisa Mattila
 */
wideload.LightGradientShader =
{
	attributes:{
	},
	
	uniforms:{
		resolution: {type:"v2", value: new THREE.Vector2(8,8)},
		time: {type:"f", value: 0.0},
	},
	
	vertex: [
		"varying vec3 vNormal;",
		
		"void main() {",
			"vNormal = normal;",
			"vec3 p = position;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
    "varying vec3 vNormal;",
    
    "uniform float time;",
    "uniform vec2 resolution;",

    "void main(void) {",
      "vec2 p = -1.0+(2.0*gl_FragCoord.xy)/(resolution.xy);",
      "p.x += 0.3*sin(time) + 0.3*cos(time);",
      "p.y += 0.3*cos(time);",
      
      "float a = atan(p.x, p.y);",
      "float r = length(p)*4.5;",
      "float col = r;",

      "gl_FragColor = vec4(1.-(col*0.2), 1.-(col*0.5),1.-(col*0.2), 1.0);",
    "}"
	].join("\n")
}