/**
 * ...
 * @author Henri Sarasvirta
 */
wideload.JuliaShader =
{
	attributes:{
		
	},
	
	uniforms:{
		zoom: {type:"f", value: 0.6},
		resolution: {type:"v2", value: new THREE.Vector2(8,8)},
		time: {type:"f", value: 164.0},
	},
	
	vertex: [
		"varying vec3 vNormal;",
		
		"void main() {",
			"vNormal = normal;",
			"vec3 p = position;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( p, 1.0 );",
		"}"
	].join("\n"),
	
	fragment:[
		"varying vec3 vNormal;",
		"uniform float zoom;",
		"uniform vec2 resolution;",
		"uniform float time;",
		"vec2 complex_square( vec2 v ) {",
			"return vec2(",
			"v.x * v.x - v.y * v.y,",
			"v.x * v.y * 2.0",
		");",
		"}",
		"void main() {",
			"vec2 uv = gl_FragCoord.xy- resolution.xy * 0.5;",
			"uv *= zoom* 1.5 / min( resolution.x, resolution.y );",
			"float t = uv.x;",
			"uv.x = uv.y;",
			"uv.y = t;",
			"vec2 c = vec2( 0.37+cos(time*1.23462673423)*0.04, sin(time*1.43472384234)*0.10+0.50);",
			"vec2 v = uv;",
			"float scale = 0.01;",
			"float smoothcolor = exp(length(v));",
			"for ( int i = 0 ; i < 17; i++ ) {",
				"v = c + complex_square( v );",
				"smoothcolor += exp(length(v));",
				"if ( dot( v, v ) > 4.0 ) {",
					"break;",
				"}",
			"}",
			"float r = 0.4*(sin(smoothcolor*0.1+time*0.63));//+pposition*0.63));",
			"float g = r*r*r;",
			"float b = r;",
			"gl_FragColor = vec4(r,g,b,0);",
		"}"
	].join("\n")
}