/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var Julia = function(main, renderCacheAmount, partId){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
	}
	var p = Julia.prototype = new wideload.BasePart();
	wideload.Julia = Julia;
	
	p.superInitialize = p.initialize;
	p.initialize = function(renderer){
		this.superInitialize(renderer);
		this.maxX = 1280/2;
		this.minX = -1280/2;
		this.maxY = 720/2;
		this.minY = -720/2;
//		this.renderTarget = new THREE.WebGLRenderTarget(1280, 720, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
		this.camera = new THREE.OrthographicCamera(this.minX,this.maxX, this.maxY, this.minY);
		
		this.shaderMaterial = new THREE.ShaderMaterial({
			uniforms: wideload.JuliaShader.uniforms,
			attributes: wideload.JuliaShader.attributes,
			vertexShader: wideload.JuliaShader.vertex,
			fragmentShader: wideload.JuliaShader.fragment,
			color: "white"
		});
		
		//var planeGeom = new THREE.PlaneGeometry(this.main.resolution.width, this.main.resolution.height);
		var planeGeom = new THREE.PlaneGeometry(1280, 720);
		
		var plane = new THREE.Mesh(planeGeom, this.shaderMaterial);
		this.scene.add(plane);
		
		this.camera.position.z = 10;
		
		this.isActive = true;
	}
	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){
		
		this.shaderMaterial.uniforms.resolution.value.x = 1280;// this.main.resolution.width;// $("#demo canvas").width()/1;
		this.shaderMaterial.uniforms.resolution.value.y = 720;//this.main.resolution.height;//$("#demo canvas").height()/1;
		
		this.shaderMaterial.uniforms.time.value = elapsedtime*0.001;
		this.renderer.render(this.scene, this.camera, renderTarget);
	}
	
	
})();

