/**
 * ...
 * @author Henri Sarasvirta
 */

(function() {
	var GenericText = function(main, renderCacheAmount, partId, text, targetWidth, size,offset){
		this.partId = partId;
		this.main = main;
		this.renderer = null; //Renderer is given from outside.
		this.renderTarget = null; //Create render target on initialize.
		this.text = text;
		this.targetWidth = targetWidth;
		this.size = size;
		this.offset = offset;
	}
	var p = GenericText.prototype = new wideload.BasePart();
	wideload.GenericText = GenericText;
	
	
	p.initialize = function(renderer){
		this.renderCacheAmount = 20;
		this.cache = new wideload.RenderBuffer(this.renderCacheAmount);
		this.scene = new THREE.Scene();
		this.renderTarget = new THREE.WebGLRenderTarget(this.main.screenResolution.width*this.targetWidth, this.main.screenResolution.height, { minFilter: THREE.LinearFilter, magFilter: THREE.NearestFilter, format: THREE.RGBFormat });
		this.renderer = renderer;
		
		this.maxX = this.main.resolution.width*this.targetWidth/2;
		this.minX = -this.main.resolution.width*this.targetWidth/2;
		this.maxY = this.main.resolution.height/2;
		this.minY = -this.main.resolution.height/2;
		
		this.camera = new THREE.OrthographicCamera(this.minX,this.maxX, this.maxY, this.minY);this.camera.position.set( 0, 0, -500 );
				
		this.scene = new THREE.Scene();
		this.texts = [];
		
		this.createText(this.text);		
		
		this.isActive = true;
	}
	
	p.createText = function(text,pos)
	{
		var text3d = new THREE.TextGeometry( text, {

			size: this.size,
			height: 80,
			curveSegments: 4,
			font: "helvetiker"			
		});
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var textMaterial = new THREE.MeshBasicMaterial( { color:  0x000000, side: THREE.DoubleSide } );
		var text = new THREE.Mesh( text3d, textMaterial );
		this.offset = this.offset || 0;
		text.position.x = +this.targetWidth*100+this.offset;// centerOffset;
		text.position.y = 50;
		text.position.z = 0;

		text.rotation.y = Math.PI;
		text.rotation.x = Math.PI;
		this.scene.add(text);
		
	}

	
	/*
	Overwrite and do render here
	*/
	p.internalRender = function(elapsedtime,renderTarget){
		/*
		
		this.shaderMaterial.uniforms.resolution.value.x = $("#demo canvas").width()/2;
		this.shaderMaterial.uniforms.resolution.value.y = $("#demo canvas").height()/2;
		
		this.shaderMaterial.uniforms.time.value = elapsedtime*0.0002;*/
		this.renderer.autoClear= true;
		this.renderer.setClearColor(0x808080);
		//this.renderer.setClearColor(0x4AC948);
		
		//this.renderer.setClearColor(0xAA00FF);
		this.renderer.render(this.scene, this.camera, renderTarget);
		this.renderer.autoClear= false;
		this.renderer.setClearColor(0x000000);
	}
	
	
})();

