/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.provider;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.server.AsyncProviderCallback;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.server.AbstractWebServiceContext;
import com.sun.xml.internal.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.internal.ws.server.provider.ProviderInvokerTube;
import java.util.logging.Level;
import java.util.logging.Logger;

class AsyncProviderInvokerTube<T>
extends ProviderInvokerTube<T> {
    private static final Logger LOGGER = Logger.getLogger("com.sun.xml.internal.ws.server.AsyncProviderInvokerTube");

    public AsyncProviderInvokerTube(Invoker invoker, ProviderArgumentsBuilder<T> providerArgumentsBuilder) {
        super(invoker, providerArgumentsBuilder);
    }

    @Override
    @NotNull
    public NextAction processRequest(@NotNull Packet packet) {
        Object t = this.argsBuilder.getParameter(packet);
        AsyncProviderCallbackImpl asyncProviderCallbackImpl = new AsyncProviderCallbackImpl(packet);
        AsyncWebServiceContext asyncWebServiceContext = new AsyncWebServiceContext(this.getEndpoint(), packet);
        LOGGER.fine("Invoking AsyncProvider Endpoint");
        try {
            this.getInvoker(packet).invokeAsyncProvider(packet, t, asyncProviderCallbackImpl, asyncWebServiceContext);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            return this.doThrow(exception);
        }
        return this.doSuspend();
    }

    @Override
    @NotNull
    public NextAction processResponse(@NotNull Packet packet) {
        return this.doReturnWith(packet);
    }

    @Override
    @NotNull
    public NextAction processException(@NotNull Throwable throwable) {
        throw new IllegalStateException("AsyncProviderInvokerTube's processException shouldn't be called.");
    }

    private class AsyncProviderCallbackImpl
    implements AsyncProviderCallback<T> {
        private final Packet request;
        private final Fiber fiber;

        public AsyncProviderCallbackImpl(Packet packet) {
            this.request = packet;
            this.fiber = Fiber.current();
        }

        @Override
        public void send(@Nullable T t) {
            if (t == null && this.request.transportBackChannel != null) {
                this.request.transportBackChannel.close();
            }
            Packet packet = AsyncProviderInvokerTube.this.argsBuilder.getResponse(this.request, t, AsyncProviderInvokerTube.this.getEndpoint().getPort(), AsyncProviderInvokerTube.this.getEndpoint().getBinding());
            this.fiber.resume(packet);
        }

        @Override
        public void sendError(@NotNull Throwable throwable) {
            RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
            Packet packet = AsyncProviderInvokerTube.this.argsBuilder.getResponse(this.request, runtimeException, AsyncProviderInvokerTube.this.getEndpoint().getPort(), AsyncProviderInvokerTube.this.getEndpoint().getBinding());
            this.fiber.resume(packet);
        }
    }

    private static final class AsyncWebServiceContext
    extends AbstractWebServiceContext {
        final Packet packet;

        AsyncWebServiceContext(WSEndpoint wSEndpoint, Packet packet) {
            super(wSEndpoint);
            this.packet = packet;
        }

        @Override
        @NotNull
        public Packet getRequestPacket() {
            return this.packet;
        }
    }
}

