/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.util.CharArray;
import com.sun.xml.internal.fastinfoset.util.ValueArray;
import com.sun.xml.internal.fastinfoset.util.ValueArrayResourceException;

public class CharArrayArray
extends ValueArray {
    private CharArray[] _array;
    private CharArrayArray _readOnlyArray;

    public CharArrayArray(int n, int n2) {
        this._array = new CharArray[n];
        this._maximumCapacity = n2;
    }

    public CharArrayArray() {
        this(10, Integer.MAX_VALUE);
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this._size; ++i) {
            this._array[i] = null;
        }
        this._size = 0;
    }

    public final CharArray[] getArray() {
        return this._array;
    }

    @Override
    public final void setReadOnlyArray(ValueArray valueArray, boolean bl) {
        if (!(valueArray instanceof CharArrayArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{valueArray}));
        }
        this.setReadOnlyArray((CharArrayArray)valueArray, bl);
    }

    public final void setReadOnlyArray(CharArrayArray charArrayArray, boolean bl) {
        if (charArrayArray != null) {
            this._readOnlyArray = charArrayArray;
            this._readOnlyArraySize = charArrayArray.getSize();
            if (bl) {
                this.clear();
            }
        }
    }

    public final CharArray get(int n) {
        if (this._readOnlyArray == null) {
            return this._array[n];
        }
        if (n < this._readOnlyArraySize) {
            return this._readOnlyArray.get(n);
        }
        return this._array[n - this._readOnlyArraySize];
    }

    public final void add(CharArray charArray) {
        if (this._size == this._array.length) {
            this.resize();
        }
        this._array[this._size++] = charArray;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int n = this._size * 3 / 2 + 1;
        if (n > this._maximumCapacity) {
            n = this._maximumCapacity;
        }
        CharArray[] charArrayArray = new CharArray[n];
        System.arraycopy(this._array, 0, charArrayArray, 0, this._size);
        this._array = charArrayArray;
    }
}

