#version 330 core

layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
layout(location = 2) in vec3 vertexnormal;

out vec2 UV;
out vec3 normal;
out vec2 speed;
out vec4 pos;
out vec3 origpos;

// for speedcomp
out vec4 oldprojected;
out vec4 newprojected;

uniform mat4 MVP;
uniform mat4 M;
uniform mat4 V;
uniform mat4 oldMVP;

vec2 computeSpeed() {
    vec4 old = oldMVP * vec4(vertexPos, 1);
    vec4 new = MVP * vec4(vertexPos, 1);
    
    oldprojected = old;
    newprojected = new;
    return 2.0 * (new.xy/new.w - old.xy/old.w);
}

void main(){
	// Transform vertices and textures.
	pos = MVP * vec4(vertexPos, 1.0);
	origpos = vertexPos;
	gl_Position =  pos;
	UV = vertexUV;

	// Vertex normal -juttua.
	vec4 transformednormal = transpose(inverse(V * M)) * vec4(vertexnormal, 0.0);
	vec3 reflected = reflect(pos.xyz, normalize(transformednormal.xyz));
	vec4 temp = vec4(normalize(reflected), 0.0);
	normal = normalize(temp.xyz);
    speed = computeSpeed();
}

