#version 330 core

in vec2 UV;
uniform sampler2D inputtex;
//uniform float KERNELW;
uniform float sigma;
uniform float iResolution;

out vec4 color;

vec4 glow(vec2 coord) {
#define KERNELW 8
    vec4 summa = vec4(0.0);
    float pixelx = 1.0 / iResolution;
    float sumnum = 0.0;
    for ( int x = -int(KERNELW)/2; x <= int(KERNELW)/2; x++) {
        //float weight = exp(-float(x * x) / (KERNELW / 0.2));
        float weight = exp(-float(x * x) / ((sigma * sigma)));
        vec2 uuz = coord + vec2(pixelx * x, 0.0);
        summa += weight * texture(inputtex, uuz);
        sumnum += weight;
    }
    return vec4(summa.rgb, 1.0) / sumnum;
}

void main(){
    vec3 blur = glow(UV).rgb;
    color = vec4(blur, 1.0);
}
