﻿//Ball scene


//length: part length in ms
//startTime: the absolute time when the part starts
//endTime: time that part need for end effect in ms
var Balls = function(duration, startTime, endTime){
  PartBase.call(this, duration, startTime, endTime);
}


Balls.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Balls.prototype.initScene = function(){

  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera();
  this.camera.position.z = 300;
  this.scene.add(this.camera);
  
  this.ballRTT = new THREE.WebGLRenderTarget(1024, 1024);
  
  var ambient = new THREE.AmbientLight(0xC1CDCD);
  this.scene.add(ambient);
  
  var pointLight = new THREE.PointLight(0x8F8FBC);
  pointLight.position.z = 100;
  this.scene.add(pointLight);
  
  var skyMaterial = new THREE.MeshLambertMaterial({
    color : 0x2E0854,
    ambient : 0x5D478B,
    emissive : 0x5D478B,
    specular : 0x483D8B,
    map : this.ballRTT,
    side: THREE.BackSide
  });
  this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(400, 16, 16), skyMaterial);
  this.skySphere.rotation.y = Math.PI/2;
  this.scene.add(this.skySphere);
  
  this.balls = new THREE.Object3D();
  this.scene.add(this.balls);
  
  this.createBalls(8);

  //some min and max values
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  
  //Sisään feidaus
  this.rtt = new THREE.WebGLRenderTarget(1024, 1024);
  this.preScene = new THREE.Scene();
  this.preCamera = new THREE.OrthographicCamera(this.minX, this.maxX, this.maxY, this.minY);
  this.preCamera.position.z = 1;
  this.preScene.add(this.preCamera);
  
  this.uniformsBlink =  {
    phase : {type : "f", value: -2.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
    texture : {type : "t", value: this.rtt}
  };

  this.blinkMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniformsBlink,
      vertexShader: document.getElementById( 'textured_vertex' ).textContent,
      fragmentShader: document.getElementById( 'blink').textContent
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.blinkMaterial);
  this.preScene.add(this.plane);
  
  this.fadeIn = {t : this.startTime+1, done : false};
  
  this.timing = {
    greets : {t: this.endTime - 5, visible : false},
  };
  
  this.rotations = {
    vyz : (Math.PI*4) / this.duration,
    vx : (Math.PI*2)/ this.duration
  };
}

//rendering function
Balls.prototype.render = function(elapsedTime){
  if(!this.fadeIn.done){
    TDEMO.renderer.render(this.scene, this.camera, this.ballRTT);
    TDEMO.renderer.render(this.scene, this.camera, this.rtt);
    TDEMO.renderer.render(this.preScene, this.preCamera);
  }
  else{
    TDEMO.renderer.render(this.scene, this.camera, this.ballRTT);
    TDEMO.renderer.render(this.scene, this.camera);
  }
}

//Operations thta takes place before rendering in every cycle
Balls.prototype.animate = function(elapsedTime){
  //alun sisäänfeidaus
  if(!this.fadeIn.done && elapsedTime >= this.fadeIn.t){
    
    this.uniformsBlink.phase.value += 0.1;
    if(this.uniformsBlink.phase.value >= 2){
      this.uniformsBlink.phase.value = 2.0;
      this.fadeIn.done = true;
      document.getElementById("greets").style.display = "block";
      document.getElementById("greets").style.opacity = 0;
    }
  }
  if(!this.timing.greets.visible && elapsedTime >= this.timing.greets.t){
    document.getElementById("greets").style.opacity = 
      parseFloat(document.getElementById("greets").style.opacity) + 0.1;
      
    if(elapsedTime >= this.timing.greets.t+5){
      this.timing.greets.visible = true;
    }
  }
  else if(elapsedTime >= this.endTime){
    document.getElementById("greets").style.opacity = 
      parseFloat(document.getElementById("greets").style.opacity) - 0.1;
  }
  
  this.balls.children[0].position.z += Math.sin(elapsedTime);
  this.balls.rotation.y = this.rotations.vyz * (elapsedTime - this.startTime);
  this.balls.rotation.x = this.rotations.vx * (elapsedTime - this.startTime);
  this.balls.rotation.z = this.rotations.vyz * (elapsedTime - this.startTime);
  
  
}

//prepare function that is called before first rendering
Balls.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;
}

//prepare function that is called before first rendering
Balls.prototype.finish = function(elapsedTime, rtt){
  
  this.animate(elapsedTime);
  TDEMO.renderer.render(this.scene, this.camera, this.ballRTT);
  TDEMO.renderer.render(this.scene, this.camera, rtt);
}

Balls.prototype.createBalls = function(balls_amount){

  var ballMaterial = new THREE.MeshPhongMaterial({
    color : 0x483D8B,
    ambient : 0x483D8B,
    emissive : 0x5D478B,
    specular : 0x5D478B
  });
  var ball = new THREE.Mesh(new THREE.SphereGeometry(18, 32, 32), ballMaterial);
  this.balls.add(ball);
  
  var r = 80;
  var delta = 2*Math.PI/balls_amount;
  var alpha = 0;
  
  for(var i = 0; i < balls_amount; ++i){
   
    var ball = new THREE.Mesh(new THREE.SphereGeometry(18, 32, 32), ballMaterial);
    
    ball.position.x = Math.sin(alpha)*r;
    ball.position.y = Math.cos(alpha)*r;
    this.balls.add(ball);
    
    alpha += delta;
  }
}