//Joku shader-efekti juttu


var Ambience = function(duration, startTime, endTime){
  //kantaluokan rakentajan kutsu
  PartBase.call(this, duration, startTime, endTime);
}

Ambience.prototype = PartBase.prototype.inheritance();

//scene is initialized before demo starts
Ambience.prototype.initScene = function(){
  
  //some min and max values
  this.minX = -TDEMO.width/2;
  this.maxX = TDEMO.width/2;
  this.minY = -TDEMO.height/2;
  this.maxY = TDEMO.height/2;
  
  //MAIN SCENE
  this.scene = new THREE.Scene();
  this.camera = new THREE.PerspectiveCamera(50, 1, 0.1, 5000);
  this.camera.position.z = 1;
  this.scene.add(this.camera);

  
  THREE.ImageUtils.crossOrigin = true;
  var texture = THREE.ImageUtils.loadTexture("bin/sprite.png");
  var spriteMaterial = new THREE.SpriteMaterial({map : texture});
  this.sprite = new THREE.Sprite(spriteMaterial);
  this.sprite.position.normalize();
  this.scene.add(this.sprite);
  
  this.createClouds();
  
}

Ambience.prototype.createClouds = function() {
  this.cloudUniforms = {time    : { type : "f", value:  0.0 },
    opacity : { type : "f", value:  0.9 },
    c0      : { type : "f", value:  5.0 },
    c1      : { type : "f", value:  3.0 },
    c2      : { type : "f", value:  11.0 },
    c3      : { type : "f", value:  7.0 },
    c4      : { type : "f", value:  9.0 },
    c5      : { type : "f", value:  3.0 },
    fogColor: { type: "c", value: 0x2E0854},
    fogNear : { type: "f", value: 1000.0 },
    fogFar  : { type: "f", value: 2000.0 },
  };
  var cloudMaterial = new THREE.ShaderMaterial({uniforms: this.cloudUniforms,
      vertexShader: document.getElementById('plasma_vertex').textContent,
      fragmentShader: document.getElementById("plasma").textContent,
      /*fog: true*/
  });

  var geo = new THREE.PlaneGeometry(1600,1600);
  this.cloudPlane = new THREE.Mesh(geo, cloudMaterial);
  this.cloudPlane.position.z = -200;
  this.scene.add(this.cloudPlane);
}




//rendering function
Ambience.prototype.render = function(elapsedTime){
  TDEMO.renderer.render(this.scene, this.camera);
}

Ambience.prototype.prepare = function(elapsedTime, rtt){
  this.startTime = elapsedTime;
}

Ambience.prototype.finish = function(elapsedTime, rtt){
  TDEMO.renderer.render(this.scene, this.camera, rtt);
}

Ambience.prototype.animate = function(elapsedTime){
  this.cloudUniforms.time.value = (elapsedTime/3);
}

