#! /usr/bin/perl
use strict;
use warnings;
my %aps = (
	Netteliten => 0,
	Parkeringsplass => 1,
	Venstre => 2,
	Bak => 3,
	"Venstre-bak" => 4,
	Hoyre => 5,
	"Hoyre-bak" => 6,
	"Senter/bootstrap" => 7,
	Kjokken => 8,
	Soverom => 9
);

for my $filename (<logs/assoc.*.txt>) {
	$filename =~ /assoc\.(\d+)\.txt/ or die;
	my $t = $1;

	my $readings = {};
	open my $fh, "<", $filename
		or die "$filename: $!";
	for (<$fh>) {
		chomp;
		/(\S+) (\d+) (\d+)/ or die;
		$readings->{$aps{$1}} += $3;
	}
	close $fh;

	my $tot = 0;
	print "$t";
	for my $i (0..9) {
		my $z = $readings->{$i} // 0;
		$tot += $z;
		#printf " %d", $z;
		printf " %d", $tot;
	}
	print "\n";
}
