window.requestAnimFrame = function() {
  return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function(h, a) {
    window.setTimeout(h, 1E3 / 60);
  };
}();

var Class = function() {
    this.initialize && this.initialize.apply(this, arguments);
};
Class.extend = function(childPrototype) { // defining a static method 'extend'
    var parent = this;
    var child = function() { // the child constructor is a call to its parent's
        return parent.apply(this, arguments);
    };
    child.extend = parent.extend; // adding the extend method to the child class
    var Surrogate = function() {}; // surrogate "trick" as seen previously
    Surrogate.prototype = parent.prototype;
    child.prototype = new Surrogate;
    for(var key in childPrototype){
        child.prototype[key] = childPrototype[key];
    }
    return child; // returning the child class
};

var image = Class.extend({
    initialize : function(h) { // initialize is called by constructor at instanciation.
        this.img = new Image();
        this.img.src = h;
        this.todraw = this.img;
        this.handley = this.handlex = 0;
        this.midhandled = !1;
        this.tilestart = this.tileh = this.tilew = 0;
        this.width = this.img.width ;
        this.height = this.img.height ;
    },
    initTile : function(a,d,b) {
        this.width = this.img.width ;
        this.height = this.img.height ;
        this.tileh = d;
        this.tilew = a;
        "undefined" != typeof b && (this.tilestart = b);
    },
    draw : function(a, d, b, h, c, f, e) {
        var k = a.contex.globalAlpha;
        "undefined" == typeof h && (h = 1);
        a.contex.globalAlpha = h;
        3 == arguments.length || 4 == arguments.length ? a.contex.drawImage(this.todraw, d - this.handlex, b - this.handley) : (5 == arguments.length ? (a.contex.translate(d, b), a.contex.rotate(c * Math.PI / 180)) : (a.contex.translate(d, b), a.contex.rotate(c * Math.PI / 180), a.contex.scale(f, e)), a.contex.translate(-this.handlex, -this.handley), a.contex.drawImage(this.todraw, 0, 0), a.contex.setTransform(1, 0, 0, 1, 0, 0));
        a.contex.globalAlpha = k;
    },
    drawTile : function(a, d, b, h, c, f, e, k) {
        var g = a.contex.globalAlpha;
        "undefined" == typeof c && (c = 1);
        a.contex.globalAlpha = c;
        this.drawPart(a, b, h, Math.floor(d % (this.width / this.tilew)) * this.tilew, Math.floor(d / (this.width / this.tilew)) * this.tileh, this.tilew, this.tileh, c, f, e, k);
        a.contex.globalAlpha = g;
    },
    drawPart : function(a, d, b, h, c, f, e, k, g, n, l) {
        var m = a.contex.globalAlpha;
        "undefined" == typeof k && (k = 1);
        a.contex.globalAlpha = k;
        7 == arguments.length || 8 == arguments.length ? a.contex.translate(d, b) : 9 == arguments.length ? (a.contex.translate(d, b), a.contex.rotate(g * Math.PI / 180)) : (a.contex.translate(d, b), a.contex.rotate(g * Math.PI / 180), a.contex.scale(n, l));
        !0 == this.midhandled ? a.contex.translate(-f / 2, -e / 2) : a.contex.translate(-this.handlex, -this.handley);
        a.contex.drawImage(this.todraw, h, c, f, e, null, null, f, e);
        a.contex.setTransform(1, 0, 0, 1, 0, 0);
        a.contex.globalAlpha = m;
    },
    setmidhandle : function() {
        if (this.img) this.width = this.img.width ;
        if (this.img) this.height = this.img.height ;
        this.handlex = parseInt(this.width / 2);
        this.handley = parseInt(this.height / 2);
        this.midhandled = !0;
    },
    sethandle : function(a,d) {
        this.handlex = a;
        this.handley = d;
        this.midhandled = !1;
    },
    print : function(a, d, b, h, c, f, e, k) {
        for (var g = 0;g < d.length;g++) {
            "undefined" != typeof e ? this.drawTile(a, d[g].charCodeAt(0) - this.tilestart, b + g *this.tilew * e, h, c, f, e, k) :this.drawTile(a, d[g].charCodeAt(0) - this.tilestart, b + g * this.tilew, h, c, f, e, k);
        }
    }
});

var canvas = image.extend({
    initialize : function(h,a,d) { // initialize is called by constructor at instanciation.
        this.canvas = document.createElement("canvas");
        this.todraw = this.canvas ;
        d && document.getElementById(d).appendChild(this.canvas);
        this.canvas.setAttribute("width", h);
        this.canvas.setAttribute("height", a);
        this.contex = this.canvas.getContext("2d");
        this.width = this.canvas.width ;
        this.height = this.canvas.height ;
        this.handley = this.handlex = 0;
        this.midhandled = !1;
        this.tilestart = this.tileh = this.tilew = 0;
    },
    clear : function() {
        this.contex.clearRect(0, 0, this.width, this.height);
    },
    fill : function(b) {
        var a = this.contex.fillStyle, c = this.contex.globalAlpha;
        this.contex.globalAlpha = 1;
        this.contex.fillStyle = b;
        this.contex.fillRect(0, 0, this.width, this.height);
        this.contex.fillStyle = a;
        this.contex.globalAlpha = c;
    },
    initTile : function(a,d,b) {
        this.tileh = d;
        this.tilew = a;
        "undefined" != typeof b && (this.tilestart = b);
    },
    setcolor : function(c) {
        this.contex.fillStyle = c ;
        this.contex.strokeStyle = c ;
    } ,
    quickplot : function(a,b,c) {
        this.contex.fillRect(a, b, c, c);
    },
    plot : function(b, a, c, f) {
        var e = this.contex.fillStyle;
        this.contex.fillStyle = f;
        this.contex.fillRect(b, a, c, c);
        this.contex.fillStyle = e;
    },
    line : function(b, a, c, f, e, k) {
        var g = this.contex.strokeStyle;
        this.contex.strokeStyle = k;
        this.contex.lineWidth = e;
        this.contex.beginPath();
        this.contex.moveTo(b, a);
        this.contex.lineTo(c, f);
        this.contex.stroke();
        this.contex.closePath();
        this.contex.strokeStyle = g;
    },
    triangle : function(b, a, c, f, e, k, g) {
        this.contex.beginPath();
        this.contex.moveTo(b, a);
        this.contex.lineTo(c, f);
        this.contex.lineTo(e, k);
        this.contex.closePath();
        this.contex.fillStyle = g;
        this.contex.fill();
    },
    quad : function(b, a, c, f, e, k, g, d, l) {
        var h = this.contex.fillStyle;
        5 == arguments.length ? (this.contex.fillStyle = e, this.contex.fillRect(b, a, c, f)) : (this.contex.beginPath(), this.contex.moveTo(b, a), this.contex.lineTo(c, f), this.contex.lineTo(e, k), this.contex.lineTo(g, d), this.contex.closePath(), this.contex.fillStyle = l, this.contex.fill());
        this.contex.fillStyle = h;
    }
});
