#version 420

uniform sampler2D tex;

const float PI = 3.141592653589793;
uniform vec2 center;
uniform float radius;
uniform float strength;

in vec2 out_TexCoord;

out vec4 fragColor;

void main()
{
  /* get vertex info */
  vec4 info = texture2D(tex, out_TexCoord);
  
  /* add the drop to the height */
  float drop = max(0.0, 1.0 - length(center * 0.5 + 0.5 - out_TexCoord) / radius);
  drop = 0.5 - cos(drop * PI) * 0.5;
  info.r += drop * strength;
  
  fragColor = info;
}