#version 420
layout(points) in;
layout(triangle_strip, max_vertices=4) out;


uniform mat4 projectionMatrix;
uniform mat4 modelMatrix;
uniform mat4 viewMatrix;

uniform vec3 camera_position;
uniform vec3 cam_forward;
uniform vec3 cam_right;
uniform vec3 cam_up;

out vec2 tex_coord;

void main()
{
	vec4 worldpos = modelMatrix * gl_in[0].gl_Position;

	vec4 forward = vec4(cam_forward, 0.0) * 0.4;
	vec4 up 	 = vec4(cam_up, 0.0) * 0.4;
	vec4 right   = vec4(cam_right, 0.0) * 0.4;

	float size = 0.1f;
	vec4 v1 = worldpos;
	// bottom right
	v1 += forward;
	v1 += right;
	v1 -= up;
	gl_Position = projectionMatrix * viewMatrix * v1;
	tex_coord = vec2(1,0);
	EmitVertex();

	vec4 v2 = worldpos;
	// top right
	v2 += forward;
	v2 += right;
	v2 += up;
	gl_Position = projectionMatrix * viewMatrix * v2;
	tex_coord = vec2(1,1);
	EmitVertex();

	vec4 v4 = worldpos;
	// bottom left
	v4 += forward;
	v4 -= right;
	v4 -= up;
	gl_Position = projectionMatrix * viewMatrix * v4;
	tex_coord = vec2(0,0);
	EmitVertex();

	vec4 v3 = worldpos;
	// top left
	v3 += forward;
	v3 -= right;
	v3 += up;
	gl_Position = projectionMatrix * viewMatrix * v3;
	tex_coord = vec2(0,1);
	EmitVertex();

	EndPrimitive();
}