#version 420

uniform mat4 projectionModelViewMatrix;
uniform mat4 textureMatrix;

in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out vec2 out_TexCoord;
out vec4 out_ProjTexCoord;

void main()
{
	out_TexCoord = in_TexCoord;
	out_ProjTexCoord = textureMatrix * vec4(in_Vertex, 1.0);
	gl_Position = projectionModelViewMatrix * vec4(in_Vertex, 1.0);
}