#version 420
// layout(points) in;
// layout(points, max_vertices=1) out;

layout(points) in;
layout(triangle_strip, max_vertices=24) out;


uniform mat4 projection_matrix;
uniform mat4 model_matrix;
uniform mat4 view_matrix;

out vec2 tex_coord;
out vec4 worldpos;
out vec4 normal;

void main()
{
	float size = 0.015;
	worldpos = gl_in[0].gl_Position * model_matrix;

	// gl_Position = projection_matrix * view_matrix * worldpos;
	// tex_coord = vec2(1,1);
	// EmitVertex();	 
	// EndPrimitive();
	float shininess = 256;

	vec4 v1 = vec4(worldpos.x - size, worldpos.y - size, worldpos.z + size, worldpos.w);
	vec4 v2 = vec4(worldpos.x + size, worldpos.y - size, worldpos.z + size, worldpos.w);
	vec4 v3 = vec4(worldpos.x - size, worldpos.y + size, worldpos.z + size, worldpos.w);
	vec4 v4 = vec4(worldpos.x + size, worldpos.y + size, worldpos.z + size, worldpos.w);

	vec4 v5 = vec4(worldpos.x - size, worldpos.y - size, worldpos.z - size, worldpos.w);
	vec4 v6 = vec4(worldpos.x + size, worldpos.y - size, worldpos.z - size, worldpos.w);
	vec4 v7 = vec4(worldpos.x - size, worldpos.y + size, worldpos.z - size, worldpos.w);
	vec4 v8 = vec4(worldpos.x + size, worldpos.y + size, worldpos.z - size, worldpos.w);

	// VOOR
	gl_Position = projection_matrix * view_matrix * v1;
	tex_coord = vec2(0,0);
	normal = vec4(0,0,1,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v2;
	tex_coord = vec2(1,0);
	normal = vec4(0,0,1,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v3;
	tex_coord = vec2(0,1);
	normal = vec4(0,0,1,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v4;
	tex_coord = vec2(1,1);
	normal = vec4(0,0,1,shininess);
	EmitVertex();	 
	EndPrimitive();


	 // ACHTER
	gl_Position = projection_matrix * view_matrix * v6;
	tex_coord = vec2(0,0);
	normal = vec4(0,0,-1,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v5;
	tex_coord = vec2(1,0);
	normal = vec4(0,0,-1,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v8;
	tex_coord = vec2(0,1);
	normal = vec4(0,0,-1,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v7;
	tex_coord = vec2(1,1);
	normal = vec4(0,0,-1,shininess);
	EmitVertex();	 
	EndPrimitive();

	 // LINKS
	gl_Position = projection_matrix * view_matrix * v1;
	tex_coord = vec2(1,0);
	normal = vec4(-1,0,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v3;
	tex_coord = vec2(1,1);
	normal = vec4(-1,0,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v5;
	tex_coord = vec2(0,0);
	normal = vec4(-1,0,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v7;
	tex_coord = vec2(0,1);
	normal = vec4(-1,0,0,shininess);
	EmitVertex();	 
	EndPrimitive();

	// RECHTS
	gl_Position = projection_matrix * view_matrix * v4;
	tex_coord = vec2(0,1);
	normal = vec4(1,0,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v2;
	tex_coord = vec2(0,0);
	normal = vec4(1,0,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v8;
	tex_coord = vec2(1,1);
	normal = vec4(1,0,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v6;
	tex_coord = vec2(1,0);
	normal = vec4(1,0,0,shininess);
	EmitVertex();	 
	EndPrimitive();


	// BOVEN
	gl_Position = projection_matrix * view_matrix * v3;
	tex_coord = vec2(0,0);
	normal = vec4(0,1,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v4;
	tex_coord = vec2(1,0);
	normal = vec4(0,1,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v7;
	tex_coord = vec2(0,1);
	normal = vec4(0,1,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v8;
	tex_coord = vec2(1,1);
	normal = vec4(0,1,0,shininess);
	EmitVertex();	 
	EndPrimitive();


	// ONDER
	gl_Position = projection_matrix * view_matrix * v2;
	tex_coord = vec2(1,1);
	normal = vec4(0,-1,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v1;
	tex_coord = vec2(0,1);
	normal = vec4(0,-1,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v6;
	tex_coord = vec2(1,0);
	normal = vec4(0,-1,0,shininess);
	EmitVertex();

	gl_Position = projection_matrix * view_matrix * v5;
	tex_coord = vec2(0,0);
	normal = vec4(0,-1,0,shininess);
	EmitVertex();	 
	EndPrimitive();
}