#version 420

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform mat4 modelMatrix;
uniform vec3 campos;

in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out vec3 out_TexCoord;

mat3 GetLinearPart( mat4 m )
{
	mat3 result;
	
	result[0][0] = m[0][0]; 
	result[0][1] = m[0][1]; 
	result[0][2] = m[0][2]; 

	result[1][0] = m[1][0]; 
	result[1][1] = m[1][1]; 
	result[1][2] = m[1][2]; 
	
	result[2][0] = m[2][0]; 
	result[2][1] = m[2][1]; 
	result[2][2] = m[2][2]; 
	
	return result;
}		
	

void main()
{
	//out_TexCoord = in_TexCoord;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(in_Vertex,1.0);

	// Color map texture coordinates. 
	// Increase a little bit the tiling by 2.
	//out_TexCoord = in_TexCoord * 2.0;
	
	mat3 orientation = GetLinearPart( modelMatrix );
	
	// find world space position.
	vec4 world_pos = modelMatrix * vec4(in_Vertex, 1.0);	
	
	// find world space normal.
	vec3 N = normalize( orientation * in_Normal ); 
	
	// find world space eye vector.
	vec3 E = normalize( world_pos.xyz - campos.xyz );	
	
	// calculate the reflection vector in world space.
	out_TexCoord.xyz = reflect( E, N ); 
}