#version 420

uniform sampler2D scatter;
uniform float time;
uniform vec2 lightPositionOnScreen;
in vec2 out_TexCoord;
out vec4 fragColor;
const int NUM_SAMPLES = 200 ;
void main()
{
	float exposure = 3.99;
	float decay = 0.7;
	float density = 2.0;
	float weight = 0.3;
	vec2 deltaTextCoord = vec2( out_TexCoord.st - lightPositionOnScreen.xy );
 	vec2 textCoo = vec2(out_TexCoord.st);
 	deltaTextCoord *= 1.0 /  NUM_SAMPLES * density;
 	float illuminationDecay = 0.5;
 	for(int i=0; i < NUM_SAMPLES ; i++)
  	{
    			textCoo -= deltaTextCoord;
    			vec4 texel = texture2D(scatter, textCoo );
    			texel *= illuminationDecay * weight;
    			fragColor += texel;
    			illuminationDecay *= decay;
 	}
 	fragColor *= exposure;
}

