#version 420

uniform sampler2D tex;
uniform sampler2D glow;
uniform vec4 color;

in vec2 out_TexCoord;
in vec3 normal;
in vec4 position;

layout(location = 0) out vec4 frag_color;
layout(location = 1) out vec4 frag_color2;
layout(location = 2) out vec4 frag_color3;
layout(location = 3) out vec4 frag_color4;
layout(location = 4) out vec4 frag_color5;

in mat3 normal_matrix;

void main()
{
	float shininess = 130.1;
	vec4 diffuse = texture2D(tex, out_TexCoord);
	vec4 glowcolor = texture2D(glow, out_TexCoord);

	vec4 world_normal = vec4(normal_matrix * normal,1);
	world_normal.a = shininess;

	frag_color = vec4(diffuse.rgb, 1);// * color;
	frag_color2 = world_normal;
	frag_color3 = position;
	frag_color4 = vec4(glowcolor);
}