#version 420

// G Buffer
uniform sampler2D diffuse_buffer;
uniform sampler2D light_buffer;
uniform sampler2D specular_buffer;
uniform float time;

in vec2 out_TexCoord;

out vec4 fragColor;

void main()
{
	vec4 diffuse = texture2D(diffuse_buffer, out_TexCoord);
	vec4 light = texture2D(light_buffer, out_TexCoord);
	vec4 specular = texture2D(specular_buffer, out_TexCoord);

	fragColor. xyz = diffuse.xyz * 0.1; //ambient
	fragColor. xyz += diffuse.xyz * light.xyz ; //lambert
	fragColor. xyz += specular.xyz; //Specular
	fragColor. a = 1.0;
}