#version 420

const float etaR = 1.14;
const float etaG = 1.12;
const float etaB = 1.10;
const float fresnelPower = 2.0;
const float F = ((1.0 - etaG) * (1.0 - etaG)) / ((1.0 + etaG) * (1.0 + etaG));

uniform samplerCube envmap;
uniform vec3 campos;

const float reflect_factor = 1.0;

uniform vec4 color;

in vec2 out_TexCoord;
in vec3 normal;
in vec4 position;

layout(location = 0) out vec4 frag_color;
layout(location = 1) out vec4 frag_color2;
layout(location = 2) out vec4 frag_color3;
layout(location = 3) out vec4 frag_color4;
layout(location = 4) out vec4 frag_color5;

in mat3 normal_matrix;

void main()
{
	float shininess = 130.1;

	vec4 world_normal = vec4(normal_matrix * normal,1);
	world_normal.a = shininess;

    vec3 i = normalize( position.xyz - campos.xyz );	
    vec3 n = normalize(world_normal.xyz);

    float ratio = F + (1.0 - F) * pow(1.0 - dot(-i, n), fresnelPower);

    vec3 refractR = vec4(refract(i, n, etaR), 1.0).xyz;
    vec3 refractG = vec4(refract(i, n, etaG), 1.0).xyz;
    vec3 refractB = vec4(refract(i, n, etaB), 1.0).xyz;

    vec3 reflectDir = vec4(reflect(i, n), 1.0).xyz;

    vec4 refractColor;
    refractColor.ra = texture(envmap, refractR).ra;
    refractColor.g  = texture(envmap, refractG).g;
    refractColor.b  = texture(envmap, refractB).b;

    vec4 reflectColor;
    reflectColor    = texture(envmap, reflectDir);

    vec3 combinedColor = mix(refractColor, reflectColor, ratio).xyz;

    frag_color = vec4(combinedColor*1.4, 1.0);
	frag_color2 = world_normal;
	frag_color3 = position;
	frag_color4 = vec4(0.2, 0.4, 0.8, 1);

}