#version 420

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform sampler2D tex;
in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out vec2 out_TexCoord;
out vec3 position;

void main()
{
	//position = in_Vertex.xzy;
	vec4 pos = vec4(in_Vertex, 1.0);
	pos = modelMatrix * pos;
	position = pos.xyz;
	out_TexCoord = in_TexCoord;

    vec4 info = texture2D(tex, in_Vertex.xy * 0.5 + 0.5);
    position.y += (info.r);

	gl_Position = projectionMatrix * modelViewMatrix * vec4(position.xzy,1.0);
}