#version 420

#include "water.inc"

uniform vec3 eye;
uniform samplerCube sky;

in vec3 position;
out vec4 fragColor;

vec3 getSurfaceRayColor(vec3 origin, vec3 ray, vec3 waterColor)
{
	vec3 color;

	vec2 t = intersectCube(origin, ray, vec3(-1.0, -poolHeight, -1.0), vec3(1.0, 2.0, 1.0));
	vec3 hit = origin + ray * t.y;
	if (hit.y < 2.0 / 12.0)
	{
		color = getWallColor(hit);
	} 
	else
	{
		color = texture(sky, ray).rgb;
		color += vec3(pow(max(0.0, dot(light, ray)), 5000.0)) * vec3(10.0, 8.0, 6.0);
	}

	if (ray.y < 0.0) 
		color *= waterColor;
	return color;
}

uniform mat4 modelMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelViewMatrix;

void main()
{
	vec2 coord = position.xz * 0.5 + 0.5;
	vec4 info = texture2D(tex, coord);

	/* make water look more "peaked" */
	 for (int i = 0; i < 5; i++)
	 {
	   coord += info.ba * 0.005;
	   info = texture2D(tex, coord);
	 }

	vec4 eye2 = vec4(eye, 1.0);
	eye2.z = -eye2.z;

//	eye2 = modelViewMatrix * eye2;

	vec3 normal = normalize(vec3(info.b, sqrt(1.0 - dot(info.ba, info.ba)), info.a));
	vec3 incomingRay = normalize(position - eye2.xyz);

	/* above water */
	vec3 reflectedRay = reflect(incomingRay, normal);
	vec3 refractedRay = refract(incomingRay, normal, IOR_AIR / IOR_WATER);
	float fresnel = mix(0.25, 1.0, pow(1.0 - dot(normal, -incomingRay), 3.0));
	
	vec3 reflectedColor = getSurfaceRayColor(position, reflectedRay, abovewaterColor);
	vec3 refractedColor = getSurfaceRayColor(position, refractedRay, abovewaterColor);
	
	vec4 clr = vec4(mix(refractedColor, reflectedColor, fresnel), 1.0);
	fragColor.rgb = clr.rgb;

	// vec4 colors = texture2D(tex, coord);
	// fragColor = colors;
}