varying vec2 texcoord;
uniform vec2 noise_r;
uniform vec2 noise_g;
uniform vec2 noise_b;
uniform float noisepower;
uniform sampler2D tex0;
uniform sampler2D noisetex;

void main(void)
{
	vec4 texel = texture2D(tex0, texcoord);	

	float dur = noise_r.x;//sin(noise_r.x*2.0*3.141592);
	float dvr = noise_r.y;//cos(noise_r.y*2.0*3.141592);
	float dug = noise_g.x;//sin(noise_g.x*2.0*3.141592);
	float dvg = noise_g.y;//cos(noise_g.y*2.0*3.141592);
	float dub = noise_b.x;//sin(noise_b.x*2.0*3.141592);
	float dvb = noise_b.y;//cos(noise_b.y*2.0*3.141592);
	
	vec2 uv_r = vec2(mod(texcoord.x+dur, 1.0), mod(texcoord.y+dvr, 1.0));
	vec2 uv_g = vec2(mod(texcoord.x+dug, 1.0), mod(texcoord.y+dvg, 1.0));
	vec2 uv_b = vec2(mod(texcoord.x+dub, 1.0), mod(texcoord.y+dvb, 1.0));
		
	vec2 off_r = texture2D(noisetex, uv_r).xy - vec2(0.5, 0.5);
	vec2 off_g = texture2D(noisetex, uv_g).xy - vec2(0.5, 0.5);
	vec2 off_b = texture2D(noisetex, uv_b).xy - vec2(0.5, 0.5);
/*
	off_r.x = sin(off_r.y*2.0*3.141592);
	off_r.y = cos(off_r.y*2.0*3.141592);
	off_g.x = sin(off_g.y*2.0*3.141592);
	off_g.y = cos(off_g.y*2.0*3.141592);
	off_b.x = sin(off_b.y*2.0*3.141592);
	off_b.y = cos(off_b.y*2.0*3.141592);
*/
	off_r *= noisepower;
	off_g *= noisepower;
	off_b *= noisepower;
	
//	vec4 texel_r = texture2D(tex0, mod(texcoord + off_r, vec2(1., 1.)));
//	vec4 texel_g = texture2D(tex0, mod(texcoord + off_g, vec2(1., 1.)));
//	vec4 texel_b = texture2D(tex0, mod(texcoord + off_b, vec2(1., 1.)));

	vec2 o1 = texcoord + off_r;
	vec2 o2 = texcoord + off_g;
	vec2 o3 = texcoord + off_b;
	
	vec4 texel_r = texture2D(tex0, o1);
	vec4 texel_g = texture2D(tex0, o2);
	vec4 texel_b = texture2D(tex0, o3);
	
	gl_FragColor = vec4(texel_r.x, texel_g.y, texel_b.z, 1.0); 
}