/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESetMultiLabelIndex;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.ReferenceValue;
import cml.kickass.values.Value;
import java.util.ArrayList;
import java.util.List;

public class MultiLabelReferenceValue
extends ReferenceValue {
    int multiLabelIndex = -1;
    private List<LabelReferenceValue> labels = new ArrayList<LabelReferenceValue>();

    public MultiLabelReferenceValue() {
        super(NumberValue.invalid);
    }

    public int getMultiLabelIndex() {
        return this.multiLabelIndex;
    }

    public int getNoOfMultiLabels() {
        return this.labels.size();
    }

    public int addMultiLabel() {
        this.labels.add(new LabelReferenceValue());
        return this.labels.size() - 1;
    }

    public void setMultiLabelIndex(int n, EvaluationState evaluationState) {
        this.multiLabelIndex = n;
        evaluationState.addSideEffect(new SESetMultiLabelIndex(n, this));
    }

    public void setMultiLabelIndexWithoutSideEffect(int n) {
        this.multiLabelIndex = n;
    }

    public LabelReferenceValue getLabelReferenceValue(int n) {
        return this.labels.get(n);
    }

    public Value getReferencedValue() {
        return this.labels.get(this.multiLabelIndex).deReference();
    }

    @Override
    public boolean keepInNextPass() {
        return true;
    }

    @Override
    public void initBeforeParse() {
        this.multiLabelIndex = -1;
    }

    @Override
    public void setValue(Value value, EvaluationState evaluationState, DebugInfo debugInfo) {
        this.labels.get(this.multiLabelIndex).setValue(value, evaluationState, debugInfo);
    }

    @Override
    public void setWithoutSideEffect(Value value) {
        this.labels.get(this.multiLabelIndex).setWithoutSideEffect(value);
    }

    public void setResolvedLabelValue(Value value, EvaluationState evaluationState, DebugInfo debugInfo) {
        this.labels.get(this.multiLabelIndex).setResolvedLabelValue(value, evaluationState, debugInfo);
    }

    @Override
    public String toString() {
        return "MultiLabelReferenveValue(idx=" + this.multiLabelIndex + ")";
    }
}

