/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.kickass.values.Value;
import java.util.List;

public class DefineDirective
extends AsmDirective {
    private DebugInfo debug;
    private List<String> ids;
    private AsmNode body;

    public DefineDirective(List<String> list, AsmNode asmNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.body = asmNode;
        this.ids = list;
    }

    @Override
    public AsmNode copy() {
        return new DefineDirective(this.ids, this.body, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        Scope scope = evaluationState.getCurrentScope();
        StdScope stdScope = new StdScope(null, evaluationState.getCurrentScope(), false);
        evaluationState.setCurrentScope(stdScope);
        evaluationState.clearFunctionSideOutput();
        evaluationState.setFunctionMode(true);
        this.body.functionParse(evaluationState);
        evaluationState.setFunctionMode(false);
        evaluationState.setCurrentScope(scope);
        SymbolScope symbolScope = scope.getSymbols();
        SymbolScope symbolScope2 = stdScope.getSymbols();
        for (String string : this.ids) {
            Value value = (Value)symbolScope2.getLocalDefinedEntities().get(string);
            if (value == null) {
                throw new AsmError("Define directive doesn't define '" + string + "'", this.debug);
            }
            value = value.deReference();
            value.lock(this.debug);
            ConstantReferenceValue constantReferenceValue = new ConstantReferenceValue(value);
            symbolScope.put(string, constantReferenceValue);
            evaluationState.addSideEffect(new SESymbolDeclaration(string, constantReferenceValue, value));
        }
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        this.body = this.body.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("Define", this.debug);
        for (String string : this.ids) {
            nodeTreeBuilder.addArg(null, string);
        }
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

