/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.values.Value;
import cml.log.Log;

public class AssertErrorDirective
extends AsmDirective {
    Log log = new Log("AssertCodeDirective");
    ExprNode testNameExpr;
    ExprNode expr;
    DebugInfo debug;
    boolean preparsed = false;

    public AssertErrorDirective(ExprNode exprNode, ExprNode exprNode2, DebugInfo debugInfo) {
        super(debugInfo);
        this.testNameExpr = exprNode;
        this.expr = exprNode2;
    }

    @Override
    public AsmNode copy() {
        return new AssertErrorDirective(this.testNameExpr, this.expr, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        boolean bl = evaluationState.getFunctionsMode();
        Scope scope = evaluationState.getCurrentScope();
        int n = evaluationState.getCallStack().getStackSize();
        AsmError asmError = null;
        try {
            this.expr.evaluate(evaluationState);
        }
        catch (AsmError asmError2) {
            asmError = asmError2;
        }
        evaluationState.getCallStack().popTilDepth(n);
        evaluationState.setFunctionMode(bl);
        evaluationState.setCurrentScope(scope);
        Value value = this.testNameExpr.evaluate(evaluationState);
        boolean bl2 = evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        if (asmError == null && bl2) {
            return this;
        }
        String string = value.getString(this.debug);
        String string2 = asmError != null ? string + " -- OK. | " + asmError.getOneLineMessage() : string + " -- ERROR IN ASSERTION!";
        evaluationState.addTextOutput(string2);
        evaluationState.getAssertManager().madeAssert(asmError == null);
        return new SideEffectOnlyOutput(evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("AssertError", this.debug);
        nodeTreeBuilder.addArg(null, this.testNameExpr);
        nodeTreeBuilder.addArg(null, this.expr);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

