/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.asmnode.metanodes;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.reciever.OutputReciever;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.NameSpaceValue;
import cml.kickass.values.SymbolScopeValue;

public class ScopeNode
extends AsmNode {
    private AsmNode body;
    private DebugInfo debug;
    private boolean addDebugToCallStack = false;
    private NameSpaceValue nameSpaceValue;
    private boolean registerInParrent = true;
    private Scope scope;

    public ScopeNode(AsmNode asmNode) {
        this(asmNode, null, false, null);
    }

    public ScopeNode(AsmNode asmNode, NameSpaceValue nameSpaceValue, boolean bl, DebugInfo debugInfo) {
        this.body = asmNode;
        this.debug = debugInfo;
        this.nameSpaceValue = nameSpaceValue;
        this.addDebugToCallStack = bl;
    }

    public ScopeNode setRegisterInParrentScope(boolean bl) {
        this.registerInParrent = bl;
        return this;
    }

    @Override
    public AsmNode copy() {
        throw NotImplementedException.intance;
    }

    public Scope getOrNewScope(EvaluationState evaluationState) {
        if (this.scope == null) {
            String string = this.nameSpaceValue == null ? null : this.nameSpaceValue.getId();
            this.scope = new StdScope(string, evaluationState.getCurrentScope(), this.registerInParrent);
        }
        return this.scope;
    }

    public void enterScope(EvaluationState evaluationState) {
        if (this.addDebugToCallStack) {
            evaluationState.getCallStack().push(this.debug);
        }
        evaluationState.setCurrentScope(this.getOrNewScope(evaluationState));
    }

    public void exitScope(EvaluationState evaluationState) {
        evaluationState.setCurrentScope(this.scope.getParrent());
        if (this.addDebugToCallStack) {
            evaluationState.getCallStack().pop();
        }
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        Scope scope = evaluationState.getCurrentScope();
        this.enterScope(evaluationState);
        if (this.nameSpaceValue != null) {
            SymbolScope symbolScope = scope.getSymbols();
            String string = this.nameSpaceValue.getId();
            SymbolScopeValue symbolScopeValue = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.nameSpaceValue.getId());
            if (symbolScopeValue != null) {
                if (!this.nameSpaceValue.isAlsoLabel()) {
                    throw new AsmError("The symbol is already in use. Can't use '" + string + "' as namespace name.", this.debug);
                }
                this.nameSpaceValue.setResolvedLabelValue(symbolScopeValue.deReference(), evaluationState, this.debug);
            }
            scope.getSymbols().put(string, this.nameSpaceValue);
            this.nameSpaceValue.setScope(this.scope);
        }
        this.body = this.body.preParse(evaluationState);
        this.exitScope(evaluationState);
        return this;
    }

    @Override
    public AsmNode registerMetaDefinitions(EvaluationState evaluationState) {
        this.body.registerMetaDefinitions(evaluationState);
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        this.enterScope(evaluationState);
        this.body = this.body.parse(evaluationState);
        this.exitScope(evaluationState);
        return this;
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        throw NotImplementedException.intance;
    }

    @Override
    public void deliverOutput(OutputReciever outputReciever) {
        this.body.deliverOutput(outputReciever);
    }

    @Override
    public boolean isFinished() {
        boolean bl = this.nameSpaceValue == null || !this.nameSpaceValue.isInvalid();
        return bl && this.body.isFinished();
    }

    @Override
    public String toString() {
        return "ScopeNode[isFinised=" + this.isFinished() + "]";
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.enterNode("Scope", this.debug);
        nodeTreeBuilder.addArg(null, this.body);
        nodeTreeBuilder.exitNode();
        return nodeTreeBuilder;
    }
}

