/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.StringFunction;
import cml.kickass.function.StringFunctionWithDebug;
import cml.kickass.function.StringX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.CharValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class StringValue
extends ImmutableValue {
    public static Value invalid = new StringValue();
    public static Value emptyString = new StringValue("");
    private String string;
    static FunctionTable functions = new StdFunctionTable(StringValue.getStandardFunctions());

    private StringValue() {
        this.setInvalid();
    }

    public StringValue(String string) {
        this.string = string;
    }

    @Override
    public String getType() {
        return this.isInvalid() ? "Invalid String" : "String";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == Value.RP_STRINGVALUE) {
            if (this.isInvalid() && this.string == null) {
                return "<<Invalid String>>";
            }
            return this.string;
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new StringX2Function("==", BooleanValue.invalid){

            @Override
            protected Value f(String string, String string2) {
                return BooleanValue.get(string.equals(string2));
            }
        });
        functions.add(new StringX2Function("!=", BooleanValue.invalid){

            @Override
            protected Value f(String string, String string2) {
                return BooleanValue.get(!string.equals(string2));
            }
        });
        functions.add(new StringFunction("size", NumberValue.invalid){

            @Override
            protected Value f(String string) {
                return new NumberValue(string.length());
            }
        });
        functions.add(new StringFunction("asBoolean", BooleanValue.invalid){

            @Override
            protected Value f(String string) {
                return BooleanValue.get(Boolean.parseBoolean(string));
            }
        });
        functions.add(new StringFunctionWithDebug("asNumber", NumberValue.invalid){

            @Override
            protected Value f(String string, DebugInfo debugInfo) {
                try {
                    return new NumberValue(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AsmError("Not a valid number : " + string, debugInfo);
                }
            }
        });
        functions.add(new Function("+", 2, invalid, true){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Value value = valueArray[0];
                Value value2 = valueArray[1];
                if (value.isInvalid() || value2.isInvalid()) {
                    return invalid;
                }
                return new StringValue(value.getString(debugInfo) + value2.getString(debugInfo));
            }
        });
        functions.add(new Function("charAt", 2, invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                String string = ((StringValue)valueArray[0]).string;
                int n = valueArray[1].getInt(debugInfo);
                if (n < 0 || string.length() <= n) {
                    throw new AsmError("Index out of bounds: " + n, debugInfo);
                }
                return new CharValue(string.charAt(n));
            }
        });
        functions.add(new Function("substring", 3, invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                String string = ((StringValue)valueArray[0]).string;
                int n = valueArray[1].getInt(debugInfo);
                int n2 = valueArray[2].getInt(debugInfo);
                if (n < 0) {
                    throw new AsmError("Start index out of bounds: " + n, debugInfo);
                }
                if (n2 > string.length()) {
                    throw new AsmError("End index out of bounds: " + n2, debugInfo);
                }
                if (n > n2) {
                    throw new AsmError("End index bigger than startindex: " + n + "," + n2, debugInfo);
                }
                return new StringValue(string.substring(n, n2));
            }
        });
    }
}

