/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class ObjVariableReference
extends ExprNode {
    private ExprNode expr;
    private String varName;

    public ObjVariableReference(ExprNode exprNode, String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.varName = string;
        this.expr = exprNode;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) throws AsmException {
        Value value = this.expr.evaluate(evaluationState);
        Value value2 = value.getVariable(this.varName, this.debug);
        if (value2 == null) {
            throw new AsmError("undefined object variable: " + this.varName, this.debug);
        }
        return value2;
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("ObjVarRef", this.varName, new ExprNode[0]);
        return exprTreeBuilder;
    }
}

