/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ReturnException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import java.util.ArrayList;

public class FunctionCall
extends ExprNode {
    private String functionName;
    private ArrayList<ExprNode> argExprs;

    public FunctionCall(String string, ArrayList<ExprNode> arrayList, DebugInfo debugInfo) {
        super(debugInfo);
        this.argExprs = arrayList;
        this.functionName = string;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) throws AsmException {
        Value value;
        Value[] valueArray = new Value[this.argExprs.size()];
        boolean bl = false;
        for (int i = 0; i < valueArray.length; ++i) {
            value = this.argExprs.get(i).evaluate(evaluationState).deReference();
            bl |= value.isInvalid();
            valueArray[i] = value;
        }
        Function function = evaluationState.getFunctionTable().get(this.functionName, valueArray, this.debug);
        evaluationState.getCallStack().push(this.debug);
        try {
            value = bl && !function.handlesInvalidArguments() ? function.getInvalidResult(valueArray) : function.execute(valueArray, evaluationState, this.debug);
        }
        catch (ReturnException returnException) {
            value = returnException.getReturnValue();
        }
        evaluationState.getCallStack().pop();
        return value;
    }

    public String toString() {
        return this.functionName + "()";
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("FuncCall", this.functionName, this.argExprs);
        return exprTreeBuilder;
    }
}

