function Effect1() {
	//init START
	console.log("Width:"+WIDTH+";Height:"+HEIGHT+";");		//size check for browser compatibility
	renderer.setSize(WIDTH, HEIGHT);
	container.appendChild(renderer.domElement);				//linking rendering window to container on the DOM
	scene2D.add(camera2D);										//lets add our camera2D to the scene2D
	var vertShader = [
		'varying vec4 verpos;',
		'void main() {',
		'gl_Position = projectionMatrix *',
		'modelViewMatrix *',
		'vec4(position,1.0);',
		'}'
		].join('\n'); 
	var startTime = demosong.currentTime;
	var fragShader = document.getElementById( 'effect1fs' ).innerHTML;

	var uniforms = {
		iResolution: {type: 'v2', value: new THREE.Vector2(WIDTH,HEIGHT)},
		globalTime: {type: 'f', value: (new Date()).getDate()},
		tie: {type: 't', value: tie},
		pyora: {type: 't', value: pyora},
		logo: {type: 't', value:logo2},
		showpyora: {type: 'f', value: 0.0},
		showtie: {type: 'f', value: 0.0}
		};
	var shaderMaterial = new THREE.ShaderMaterial({
		vertexShader: vertShader, 
		fragmentShader: fragShader,
		uniforms: uniforms
		}
		);
	var geo = new THREE.Geometry();
	geo.vertices.push(new THREE.Vector3(-1.0, -1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(1.0, -1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(1.0, 1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(-1.0, 1.0, 0.0));
	geo.faces.push( new THREE.Face3(0,1,2));
	geo.faces.push( new THREE.Face3(0,2,3));
	var cube = new THREE.Mesh( geo, shaderMaterial);
	cube.position.z=-1;
	scene2D.add(cube);
	//getters
	/*NONE :-)*/
	//setters
	/*
	 *updates screen!!!1111onenoneoneelevenelevenonehundredandaeleven
	 */
	this.updateScreen = function() {
		var pi=3.1415;
		uniforms.globalTime.value = (demosong.currentTime - startTime);
		var timer = (demosong.currentTime - startTime);
		var showp=0;
		var showt=0;
		if(	(timer>6.0 && timer<10.0 ) || 
			(timer>11.0 && timer<15.0 ) || 
			(timer>30.0 && timer<34.0 ) || 
			(timer>35.0 && timer<39.0 ) ){
			showp+=Math.max(Math.sin(pi*timer*180.0/180.0)/2.5, 0.0)*timer*0.066;
			showt+=Math.max(Math.sin(pi*(180.0+timer*180.0)/180.0)/2.5, 0.0)*timer*0.066;
		}
		if(	(timer>38.8 &&  timer<49.2 )){
			showp+=Math.max(Math.sin(pi*(0.4+timer)*180.0/180.0)/2.5, 0.0)*timer*0.066;
			showt+=Math.max(Math.sin(pi*(180.0+(0.4+timer)*180.0)/180.0)/2.5, 0.0)*timer*0.066;
		}

		uniforms.showpyora.value = showp;
		uniforms.showtie.value = showt;

		renderer.render(scene2D, camera2D);
	};
};
