
struct Light {
	vec3 pos;	// position in view (camera) coordinates
	vec3 intensity;
	vec3 dir;
	bool enabled;
	//float falloff;
};

struct Screen
{
	vec2 size;
};

uniform Screen screen;

uniform mat4 modelMatrix;
uniform mat4 viewProjectMatrix; 

uniform float p_time;
uniform float p_beat;

layout(std140) uniform TransformMatrices
{
    mat4 viewMatrix;
    mat4 projectionMatrix;
	mat4 inverseViewMatrix;
	mat4 inverseProjectionMatrix;
};

layout(std140) uniform LightArray
{
	Light spot[8];
	
} lights;

#define MAX_LIGHTS (8)
// the index of the spotlight that casts shadows
#define SHADOW_SPOT_INDEX (0)
