#include "uniforms.glsl"
#include "utils.glsl"
#line 3

#ifdef VERT_SHADER
#include "geometry_vertex_io.glsl"

uniform float p_geom_distort;
uniform float p_shake;

void process() 
{
	vec4 pos = (modelMatrix)*in_Position;

	float alpha = p_geom_distort;
	
	pos.y *= 1.5;
	
	mat2 rot = mat2(cos(alpha),  -sin(alpha),
					sin(alpha), cos(alpha));	
					
	pos.xy = pos.xy*rot;
	pos.xy += camshake(p_beat*1.5) * p_shake;
	
	ex_Position = viewMatrix*pos;
	gl_Position = (projectionMatrix*viewMatrix)*pos; 
}

#define PROCESSING_FUNCTION process
#include "geometry_base_vertex.glsl"
#endif


#ifdef FRAG_SHADER
#include "geometry_base_fragment_io.glsl"
void main()
{
	vec4 sampld = texture(tex, ex_UV.xy);
	vec3 col = sampld.rgb;

	if (sampld.a <= ALPHA_TEST_THRESHOLD) {
		discard;
	}
	
	col.rgb = mix(vec3(0.0, 0.0, 0.0), col.rgb, min(1.0, (40000.0/pow(length(ex_Position.z), 2.0))*1.0));
	//col.rgb *= vec3(0.0, 0.1, 0.2);
	
	out_Color = vec4(col, 1.0);
	
	out_Position = ex_Position.xyz;
	out_Normal.xyz = compressv3(ex_Normal.xyz);
	out_Material = vec4(0.0, 0.0, 0.0, 0.0);
}

#endif