#include "matrix.hlsl"
#include "inout.hlsl"

PIT_INSTANCE Instance_VS(VIT_INSTANCE input)
{
    PIT_INSTANCE output;

  	// Change the position vector to be 4 units for proper matrix calculations.
    input.position.w = 1.0f;

	// scale
    input.position.x *= input.instanceScale.x;
    input.position.y *= input.instanceScale.y;
    input.position.z *= input.instanceScale.z;
/*
	// rotation
	float dx, dy, dz;
	float s, c;
	matrix rotX, rotY, rotZ;

	dx = 45.0f;

	s = radians(sin(dx));
	c = radians(cos(dx));

	rotX._22 =  c; rotX._23 = -s;
	rotX._32 =  s; rotX._33 =  c;

//	worldMatrix = mul(worldMatrix, worldMatrix);
*/

	// translate
    input.position.x += input.instancePos.x;
    input.position.y += input.instancePos.y;
    input.position.z += input.instancePos.z;

	// Calculate the position of the vertex against the world, view, and projection matrices.
    output.position = mul(input.position, worldMatrix);
    output.position = mul(output.position, viewMatrix);
    output.position = mul(output.position, projectionMatrix);

	 // Calculate the normal vector against the world matrix only.
    output.normal = mul(input.normal, (float3x3)worldMatrix);
    output.normal = normalize(output.normal);

  	// Store the input color for the pixel shader to use.
	output.color = input.instanceCol;

	return output;
}