#include "matrix.hlsl"
#include "inout.hlsl"

[maxvertexcount(4)]
void Billboard_GS (point GIT_BB p[1], inout TriangleStream<PIT_BB> triStream)
{
    //create sprite quad
	PIT_BB v;

	float fXsize = p[0].size.x / p[0].position.z;
	float fYsize = p[0].size.y / p[0].position.z;
    //--------------------------------------------
	v.color = p[0].color;

    //bottom left
    v.position = float4(p[0].position.x - fXsize, p[0].position.y - fYsize, p[0].position.z, 1);
    v.position = mul(v.position, projectionMatrix);
	v.tex = float2(0.0f, 1.0f);
    triStream.Append(v);

    //top left
    v.position = float4(p[0].position.x - fXsize, p[0].position.y + fYsize, p[0].position.z, 1);
	v.position = mul(v.position, projectionMatrix);
	v.tex = float2(0.0f, 0.0f);
    triStream.Append(v);

    //bottom right
    v.position = float4(p[0].position.x + fXsize, p[0].position.y - fYsize, p[0].position.z, 1);
	v.position = mul(v.position, projectionMatrix);
	v.tex = float2(1.0f, 1.0f);
    triStream.Append(v);

    //top right
    v.position = float4(p[0].position.x + fXsize, p[0].position.y + fYsize, p[0].position.z, 1);
	v.position = mul(v.position, projectionMatrix);
	v.tex = float2(1.0f, 0.0f);
    triStream.Append(v);
}