define( ["three", "renderer"], function ( THREE, renderer ) {
  var camera = new THREE.PerspectiveCamera( 45, window.innerWidth / window.innerHeight, 1, 5000 );

  camera.reset = function() {
    camera.position.set(0, 0, 100);
    camera.rotation.set(0, 0, 0);
  }

  camera.reset();

  var updateSize = function () {
    camera.aspect = window.innerWidth / window.innerHeight;
    renderer.setSize(window.innerWidth, window.innerHeight);
    camera.updateProjectionMatrix();
  };
  window.addEventListener( 'resize', updateSize, false );
  updateSize();

  return camera;
} );
