/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.nio.IntBuffer;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLXContext;
import jogamp.opengl.x11.glx.X11GLXDrawable;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory;

public class X11ExternalGLXContext
extends X11GLXContext {
    private X11ExternalGLXContext(Drawable drawable, long l) {
        super(drawable, null);
        this.contextHandle = l;
        GLContextShareSet.contextCreated(this);
        if (!this.setGLFunctionAvailability(false, 0, 0, 2, false, false)) {
            throw new InternalError("setGLFunctionAvailability !strictMatch failed");
        }
        this.getGLStateTracker().setEnabled(false);
    }

    protected static X11ExternalGLXContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        Object object;
        long l = GLX.glXGetCurrentContext();
        if (l == 0L) {
            throw new GLException("Error: current context null");
        }
        long l2 = GLX.glXGetCurrentDisplay();
        if (l2 == 0L) {
            throw new GLException("Error: current display null");
        }
        long l3 = GLX.glXGetCurrentDrawable();
        if (l3 == 0L) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable/context current");
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        GLX.glXQueryDrawable(l2, l3, 32797, intBuffer);
        int n = intBuffer.get(0);
        GLX.glXQueryDrawable(l2, l3, 32798, intBuffer);
        int n2 = intBuffer.get(0);
        GLX.glXQueryContext(l2, l, 32780, intBuffer);
        X11GraphicsScreen x11GraphicsScreen = (X11GraphicsScreen)X11GraphicsScreen.createScreenDevice(l2, intBuffer.get(0), false);
        GLX.glXQueryContext(l2, l, 32787, intBuffer);
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = null;
        if (0 == intBuffer.get(0) || !X11GLXGraphicsConfiguration.GLXFBConfigIDValid(l2, x11GraphicsScreen.getIndex(), intBuffer.get(0))) {
            object = new GLCapabilities(GLProfile.getDefault());
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)object, (GLCapabilitiesImmutable)object, null, x11GraphicsScreen, 0);
            if (DEBUG) {
                System.err.println("X11ExternalGLXContext invalid FBCONFIG_ID " + intBuffer.get(0) + ", using default cfg: " + x11GLXGraphicsConfiguration);
            }
        } else {
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfiguration.create(gLProfile, x11GraphicsScreen, intBuffer.get(0));
        }
        object = new WrappedSurface(x11GLXGraphicsConfiguration, l3, n, n2, true);
        return new X11ExternalGLXContext(new Drawable(gLDrawableFactory, (NativeSurface)object), l);
    }

    @Override
    protected boolean createImpl(long l) {
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
    }

    static class Drawable
    extends X11GLXDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
            super(gLDrawableFactory, nativeSurface, true);
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        @Override
        public int getWidth() {
            throw new GLException("Should not call this");
        }

        @Override
        public int getHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }
    }
}

