/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PShader;

public class demo
extends PApplet {
    Moonlander moonlander;
    Boxez boxez = new Boxez();
    Tesla t = new Tesla();

    public void setup() {
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"data/ruuvvailu_8.mp3", (int)128, (int)8);
        this.blendMode(2);
        this.t.setup();
        this.boxez.setup();
        this.moonlander.start();
    }

    public void draw() {
        this.moonlander.update();
        int n = this.moonlander.getIntValue("scene");
        boolean bl = false;
        if (n == 0) {
            this.t.draw();
        } else if (n == 1) {
            if (!bl) {
                bl = true;
                this.resetMatrix();
                boolean bl2 = false;
                while (!bl2) {
                    try {
                        this.popMatrix();
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                }
                this.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / demo.tan((float)0.5235988f), (float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            }
            this.boxez.draw();
        } else if (n == 2) {
            this.boxez.filterOnly();
        } else {
            this.exit();
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Boxez {
        double lastFrame = 0.0;
        float rate = 40.0f;
        PShader horizBlurShader;
        PShader vertBlurShader;
        PShader rays;
        ArrayList<Box> boxes = new ArrayList();
        float boxSpawnTime = 100.0f;
        float boxAccumulator = 100.0f;
        int maxBoxes = 20;
        int disableIndex = 0;
        boolean added = false;
        PVector curCamPos = new PVector();
        PVector nextCamPos = new PVector();
        PVector oldCamPos = new PVector();
        float camSpeed = 0.1f;
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        float ex = 0.0f;
        float ey = 0.0f;
        float ez = 0.0f;
        int br = 0;
        int bg = 0;
        int bb = 0;

        Boxez() {
        }

        public void setup() {
            demo.this.randomSeed(4919L);
            this.horizBlurShader = demo.this.loadShader("blur_frag.glsl");
            this.horizBlurShader.set("pixelSize", 1.0f / (float)demo.this.width, 0.0f);
            this.vertBlurShader = demo.this.loadShader("blur_frag.glsl");
            this.vertBlurShader.set("pixelSize", 1.0f / (float)demo.this.width, 0.0f);
            this.rays = demo.this.loadShader("rays.glsl");
            this.rays.set("decay", 0.8f);
            this.rays.set("density", 0.2f);
            this.rays.set("weight", 0.2f);
            this.rays.set("exposure", 0.5f);
            this.rays.set("light", 0.5f, 0.5f);
            this.lastFrame = demo.this.moonlander.getCurrentTime();
        }

        public void createBox() {
            if (this.boxes.size() + 1 > this.maxBoxes) {
                this.boxes.get(this.disableIndex).disable();
                ++this.disableIndex;
            }
            this.added = true;
            this.boxes.add(new Box());
        }

        public void transformBoxes() {
            for (Box box : this.boxes) {
                box.transform();
                demo.this.printCamera();
            }
        }

        public void renderBoxes(float f) {
            demo.this.pushMatrix();
            for (Box box : this.boxes) {
                box.render(f);
            }
            demo.this.popMatrix();
        }

        public void draw() {
            this.cx = (float)demo.this.moonlander.getValue("camX");
            this.cy = (float)demo.this.moonlander.getValue("camY");
            this.cz = (float)demo.this.moonlander.getValue("camZ");
            this.ex = (float)demo.this.moonlander.getValue("eyeX");
            this.ey = (float)demo.this.moonlander.getValue("eyeY");
            this.ez = (float)demo.this.moonlander.getValue("eyeZ");
            this.br = demo.this.moonlander.getIntValue("br");
            this.bg = demo.this.moonlander.getIntValue("bg");
            this.bb = demo.this.moonlander.getIntValue("bb");
            float f = 0.0f;
            float f2 = (float)demo.this.moonlander.getCurrentTime();
            f = (float)((double)f2 - this.lastFrame) * 1000.0f;
            this.lastFrame = f2;
            f = demo.max((float)0.0f, (float)f);
            f = demo.min((float)f, (float)16.0f);
            this.boxAccumulator += f;
            if (this.boxAccumulator >= this.boxSpawnTime) {
                this.createBox();
                this.boxAccumulator -= this.boxSpawnTime;
            }
            demo.this.fill(this.br, this.bg, this.bb, 16.0f);
            demo.this.strokeWeight(4.0f);
            demo.this.lights();
            demo.this.pointLight(255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            demo.this.camera((float)demo.this.width / 2.0f, (float)demo.this.height / 2.0f, (float)demo.this.height / 2.0f / demo.tan((float)0.5235988f), (float)demo.this.width / 2.0f, (float)demo.this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            this.filterOnly();
            demo.this.camera(this.ex, this.ey, this.ez, this.cx, this.cy, this.cz, 0.0f, 1.0f, 0.0f);
            demo.this.blendMode(2);
            this.renderBoxes(f);
        }

        public void filterOnly() {
            demo.this.filter(this.rays);
            demo.this.filter(this.horizBlurShader);
            demo.this.filter(this.vertBlurShader);
        }

        class Box {
            float rX;
            float rY;
            float rZ;
            boolean render = true;
            static final float thickness = 30.0f;
            static final float length = 60.0f;
            static final float scaleRate = 8.0f;
            float scale = 2.0f;

            Box() {
                this.rX = demo.radians((float)demo.this.random(0.0f, 50.0f));
                this.rY = demo.radians((float)demo.this.random(0.0f, 50.0f));
                this.rZ = demo.radians((float)demo.this.random(0.0f, 50.0f));
            }

            public void disable() {
                this.render = false;
            }

            public void transform() {
                demo.this.translate(0.0f, 45.0f * this.scale, 0.0f);
                demo.this.rotateX(this.rX);
                demo.this.rotateY(this.rY);
                demo.this.rotateZ(this.rZ);
            }

            private void render(float f) {
                if (this.scale > 1.0f) {
                    this.scale -= 8.0f * (f / 1000.0f);
                }
                this.scale = demo.max((float)this.scale, (float)1.0f);
                this.transform();
                if (this.render) {
                    demo.this.box(30.0f * this.scale, 60.0f * this.scale, 30.0f * this.scale);
                }
            }
        }
    }

    class Tesla {
        PShape tesla;
        PShape room;
        PShape decentodds;
        PShape crank;
        PShape flamero;
        PShape cce;
        PShape title;
        int CANVAS_WIDTH = 800;
        int CANVAS_HEIGHT = 600;
        float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
        float rotation = 0.0f;

        Tesla() {
        }

        public void setup() {
            this.tesla = demo.this.loadShape("tesla.obj");
            this.room = demo.this.loadShape("room.obj");
            this.decentodds = demo.this.loadShape("decentodds.obj");
            this.crank = demo.this.loadShape("crank.obj");
            this.flamero = demo.this.loadShape("flamero.obj");
            this.cce = demo.this.loadShape("cce.obj");
            this.title = demo.this.loadShape("extreme.obj");
        }

        public void draw() {
            float f;
            float f2;
            float f3;
            demo.this.moonlander.update();
            demo.this.background(0);
            demo.this.resetMatrix();
            int n = demo.this.moonlander.getIntValue("ambientlights");
            int n2 = demo.this.moonlander.getIntValue("directionalLights");
            demo.this.ambientLight(n, n, n);
            demo.this.directionalLight(n2, n2, n2, 0.0f, 1.0f, -1.0f);
            float f4 = (float)demo.this.moonlander.getValue("fov");
            float f5 = (float)demo.this.height / 2.0f / demo.tan((float)(f4 / 2.0f));
            demo.this.perspective(f4, PApplet.parseFloat((int)demo.this.width) / PApplet.parseFloat((int)demo.this.height), f5 / 10.0f, f5 * 10.0f);
            int n3 = demo.this.moonlander.getIntValue("rotate");
            float f6 = (float)demo.this.moonlander.getValue("rotatedistance");
            float f7 = (float)demo.this.moonlander.getValue("rotatespeed");
            if (n3 == 1) {
                f3 = (float)demo.this.millis() / f7;
                f2 = demo.cos((float)demo.radians((float)f3)) * f6;
                f = demo.sin((float)demo.radians((float)f3)) * f6;
                this.rotation += 1.0f;
            } else {
                f2 = (float)demo.this.moonlander.getValue("eyeX");
                f = (float)demo.this.moonlander.getValue("eyeZ");
            }
            f3 = (float)demo.this.moonlander.getValue("eyeY");
            float f8 = (float)demo.this.moonlander.getValue("centerX");
            float f9 = (float)demo.this.moonlander.getValue("centerY");
            float f10 = (float)demo.this.moonlander.getValue("centerZ");
            demo.this.camera(f2, f3, f, f8, f9, f10, 0.0f, 1.0f, 0.0f);
            int n4 = demo.this.moonlander.getIntValue("enableText");
            int n5 = demo.this.moonlander.getIntValue("musicby");
            int n6 = demo.this.moonlander.getIntValue("textRotate");
            int n7 = demo.this.moonlander.getIntValue("textZ");
            if (n4 > 0 && n4 < 6) {
                demo.this.translate(0.0f, 0.0f, n7);
                demo.this.rotateY(demo.radians((float)n6));
                this.drawText(n4);
                if (n5 == 1) {
                    demo.this.rotateY(demo.radians((float)180.0f));
                    demo.this.textSize(24.0f);
                    demo.this.textAlign(3);
                    demo.this.text("music by", 0.0f, -70.0f);
                    demo.this.fill(255);
                }
            }
            int n8 = demo.this.moonlander.getIntValue("volts");
            int n9 = demo.this.moonlander.getIntValue("enableTesla");
            if (n9 == 1) {
                demo.this.blendMode(1);
                this.room();
                this.drawTesla(n8);
            }
            int n10 = demo.this.moonlander.getIntValue("moreCoils");
            float f11 = (float)demo.this.moonlander.getValue("coilMultiplier");
            int n11 = demo.this.moonlander.getIntValue("coilAmount");
            if (n10 == 1) {
                int n12 = 1;
                while (n12 < n11) {
                    demo.this.pushMatrix();
                    demo.this.rotateY(demo.radians((float)(30.0f * f11 * (float)n12)));
                    demo.this.translate(0.0f, 0.0f, f11 * (float)n12 + 200.0f);
                    this.drawTesla(n8);
                    demo.this.popMatrix();
                    ++n12;
                }
            }
        }

        public void drawTesla(int n) {
            demo.this.pushMatrix();
            this.teslacoil();
            int n2 = 1;
            while (n2 <= 8) {
                this.lightning(0.0f, n);
                demo.this.rotateX(demo.radians((float)demo.this.random(0.0f, 10.0f)));
                demo.this.rotateY(demo.radians((float)demo.this.random(0.0f, 360.0f)));
                demo.this.rotateZ(demo.radians((float)demo.this.random(0.0f, 10.0f)));
                ++n2;
            }
            demo.this.popMatrix();
        }

        public void drawText(int n) {
            demo.this.pushMatrix();
            demo.this.scale(100.0f);
            if (n == 1) {
                demo.this.shape(this.decentodds);
            }
            if (n == 2) {
                demo.this.shape(this.crank);
            }
            if (n == 3) {
                demo.this.shape(this.flamero);
            }
            if (n == 4) {
                demo.this.shape(this.cce);
            }
            if (n == 5) {
                demo.this.shape(this.title);
            }
            demo.this.popMatrix();
        }

        public void teslacoil() {
            demo.this.pushMatrix();
            demo.this.scale(100.0f);
            demo.this.shape(this.tesla);
            demo.this.popMatrix();
        }

        public void room() {
            demo.this.pushMatrix();
            demo.this.scale(100.0f);
            demo.this.shape(this.room);
            demo.this.popMatrix();
        }

        public void lightning(float f, int n) {
            if (n <= 4) {
                return;
            }
            int n2 = (int)demo.this.random(4.0f, n);
            int n3 = demo.this.width / 4 / n2;
            demo.this.pushMatrix();
            int n4 = 0;
            while (n4 < n2) {
                float f2 = (float)n3 + demo.this.random(10.0f, 64.0f);
                float f3 = demo.this.random(150.0f, 255.0f);
                demo.this.fill(f3, f3, 255.0f);
                demo.this.noStroke();
                demo.this.box(3.0f, 3.0f, f2);
                demo.this.rotateX(demo.radians((float)demo.this.random(-10.0f, 10.0f)));
                demo.this.rotateY(demo.radians((float)demo.this.random(-15.0f, 15.0f)));
                demo.this.rotateZ(demo.radians((float)demo.this.random(-10.0f, 10.0f)));
                demo.this.translate(0.0f, 0.0f, f2 - 10.0f);
                f = f2;
                if (demo.this.random(0.0f, 8.0f) >= 4.0f) {
                    this.lightning(f, n / 2);
                }
                ++n4;
            }
            demo.this.popMatrix();
        }
    }
}

