/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.io.File;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import moonlander.library.Connector;
import moonlander.library.Controller;
import moonlander.library.Track;
import moonlander.library.TrackContainer;
import moonlander.library.TrackKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ProjectFileConnector
extends Connector {
    public ProjectFileConnector(Logger logger, TrackContainer trackContainer, Controller controller, String string) throws Exception {
        super(logger, trackContainer, controller);
        try {
            this.readAndLoadTracks(string);
        }
        catch (Exception exception) {
            this.close();
            throw exception;
        }
        controller.play();
    }

    private void readAndLoadTracks(String string) throws Exception {
        this.logger.info("Loading tracks from '" + string + "'.");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        NodeList nodeList = document.getElementsByTagName("track");
        int n = nodeList.getLength();
        this.logger.finer("Total number of tracks: " + n);
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList nodeList2 = element.getElementsByTagName("key");
            if (nodeList2.getLength() <= 0) continue;
            Track track = this.tracks.getOrCreate(element.getAttribute("name"));
            int n2 = nodeList2.getLength();
            this.logger.finest("Loading track (name=" + element.getAttribute("name") + " keys=" + n2 + ")");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                int n3 = Integer.parseInt(element2.getAttribute("row"));
                float f = Float.parseFloat(element2.getAttribute("value"));
                int n4 = Integer.parseInt(element2.getAttribute("interpolation"));
                track.addOrUpdateKey(new TrackKey(n3, f, n4));
            }
        }
    }

    @Override
    public void update() {
    }
}

