/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleRange {
    @XmlAttribute
    public double min;
    @XmlAttribute
    public double max;
    @XmlAttribute(name="default")
    public double currValue;
    protected Random random = new Random();

    public static DoubleRange fromSamples(List<Double> list) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (double d3 : list) {
            d = MathUtils.min(d, d3);
            d2 = MathUtils.max(d2, d3);
        }
        return new DoubleRange(d, d2);
    }

    public DoubleRange() {
        this(0.0, 1.0);
    }

    public DoubleRange(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.currValue = d;
    }

    public double adjustCurrentBy(double d) {
        return this.setCurrent(this.currValue + d);
    }

    public DoubleRange copy() {
        DoubleRange doubleRange = new DoubleRange(this.min, this.max);
        doubleRange.currValue = this.currValue;
        doubleRange.random = this.random;
        return doubleRange;
    }

    public double getCurrent() {
        return this.currValue;
    }

    public double getMedian() {
        return (this.min + this.max) * 0.5;
    }

    public boolean isValueInRange(float f) {
        return (double)f >= this.min && (double)f <= this.max;
    }

    public double pickRandom() {
        this.currValue = MathUtils.random(this.random, (float)this.min, (float)this.max);
        return this.currValue;
    }

    public DoubleRange seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public double setCurrent(double d) {
        this.currValue = MathUtils.clip(d, this.min, this.max);
        return this.currValue;
    }

    public DoubleRange setRandom(Random random) {
        this.random = random;
        return this;
    }

    public Double[] toArray(double d) {
        LinkedList<Double> linkedList = new LinkedList<Double>();
        for (double d2 = this.min; d2 < this.max; d2 += d) {
            linkedList.add(d2);
        }
        return linkedList.toArray(new Double[0]);
    }

    public String toString() {
        return "DoubleRange: " + this.min + " -> " + this.max;
    }
}

