/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.geom.AABB;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec2D;
import toxi.math.InterpolateStrategy;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vec3D
implements Comparable<ReadonlyVec3D>,
ReadonlyVec3D {
    public static final ReadonlyVec3D X_AXIS = new Vec3D(1.0f, 0.0f, 0.0f);
    public static final ReadonlyVec3D Y_AXIS = new Vec3D(0.0f, 1.0f, 0.0f);
    public static final ReadonlyVec3D Z_AXIS = new Vec3D(0.0f, 0.0f, 1.0f);
    public static final ReadonlyVec3D ZERO = new Vec3D();
    public static final ReadonlyVec3D MIN_VALUE = new Vec3D(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
    public static final ReadonlyVec3D MAX_VALUE = new Vec3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    @XmlAttribute(required=true)
    public float x;
    @XmlAttribute(required=true)
    public float y;
    @XmlAttribute(required=true)
    public float z;

    public static final Vec3D fromXYTheta(float f) {
        return new Vec3D((float)Math.cos(f), (float)Math.sin(f), 0.0f);
    }

    public static final Vec3D fromXZTheta(float f) {
        return new Vec3D((float)Math.cos(f), 0.0f, (float)Math.sin(f));
    }

    public static final Vec3D fromYZTheta(float f) {
        return new Vec3D(0.0f, (float)Math.cos(f), (float)Math.sin(f));
    }

    public static final Vec3D max(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        return new Vec3D(MathUtils.max(readonlyVec3D.x(), readonlyVec3D2.x()), MathUtils.max(readonlyVec3D.y(), readonlyVec3D2.y()), MathUtils.max(readonlyVec3D.z(), readonlyVec3D2.z()));
    }

    public static final Vec3D min(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        return new Vec3D(MathUtils.min(readonlyVec3D.x(), readonlyVec3D2.x()), MathUtils.min(readonlyVec3D.y(), readonlyVec3D2.y()), MathUtils.min(readonlyVec3D.z(), readonlyVec3D2.z()));
    }

    public static final Vec3D randomVector() {
        return Vec3D.randomVector(MathUtils.RND);
    }

    public static final Vec3D randomVector(Random random) {
        Vec3D vec3D = new Vec3D(random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f);
        return vec3D.normalize();
    }

    public Vec3D() {
    }

    public Vec3D(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vec3D(ReadonlyVec3D readonlyVec3D) {
        this.x = readonlyVec3D.x();
        this.y = readonlyVec3D.y();
        this.z = readonlyVec3D.z();
    }

    public final Vec3D abs() {
        this.x = MathUtils.abs(this.x);
        this.y = MathUtils.abs(this.y);
        this.z = MathUtils.abs(this.z);
        return this;
    }

    @Override
    public final Vec3D add(float f, float f2, float f3) {
        return new Vec3D(this.x + f, this.y + f2, this.z + f3);
    }

    @Override
    public Vec3D add(ReadonlyVec3D readonlyVec3D) {
        return new Vec3D(this.x + readonlyVec3D.x(), this.y + readonlyVec3D.y(), this.z + readonlyVec3D.z());
    }

    @Override
    public final Vec3D add(Vec3D vec3D) {
        return new Vec3D(this.x + vec3D.x, this.y + vec3D.y, this.z + vec3D.z);
    }

    public final ReadonlyVec3D addSelf(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    public final Vec3D addSelf(Vec3D vec3D) {
        this.x += vec3D.x;
        this.y += vec3D.y;
        this.z += vec3D.z;
        return this;
    }

    @Override
    public final float angleBetween(ReadonlyVec3D readonlyVec3D) {
        return (float)Math.acos(this.dot(readonlyVec3D));
    }

    @Override
    public final float angleBetween(ReadonlyVec3D readonlyVec3D, boolean bl) {
        float f = bl ? this.getNormalized().dot(readonlyVec3D.getNormalized()) : this.dot(readonlyVec3D);
        return (float)Math.acos(f);
    }

    public final ReadonlyVec3D clear() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    @Override
    public int compareTo(ReadonlyVec3D readonlyVec3D) {
        if (this.x == readonlyVec3D.x() && this.y == readonlyVec3D.y() && this.z == readonlyVec3D.z()) {
            return 0;
        }
        return (int)(this.magSquared() - readonlyVec3D.magSquared());
    }

    public final Vec3D constrain(AABB aABB) {
        return this.constrain(aABB.getMin(), aABB.getMax());
    }

    public final Vec3D constrain(Vec3D vec3D, Vec3D vec3D2) {
        this.x = MathUtils.clip(this.x, vec3D.x, vec3D2.x);
        this.y = MathUtils.clip(this.y, vec3D.y, vec3D2.y);
        this.z = MathUtils.clip(this.z, vec3D.z, vec3D2.z);
        return this;
    }

    @Override
    public Vec3D copy() {
        return new Vec3D(this);
    }

    @Override
    public final Vec3D cross(ReadonlyVec3D readonlyVec3D) {
        return new Vec3D(this.y * readonlyVec3D.z() - readonlyVec3D.y() * this.z, this.z * readonlyVec3D.x() - readonlyVec3D.z() * this.x, this.x * readonlyVec3D.y() - readonlyVec3D.x() * this.y);
    }

    public final Vec3D cross(Vec3D vec3D) {
        return new Vec3D(this.y * vec3D.z - vec3D.y * this.z, this.z * vec3D.x - vec3D.z * this.x, this.x * vec3D.y - vec3D.x * this.y);
    }

    @Override
    public final Vec3D crossInto(ReadonlyVec3D readonlyVec3D, Vec3D vec3D) {
        float f = readonlyVec3D.x();
        float f2 = readonlyVec3D.y();
        float f3 = readonlyVec3D.z();
        vec3D.x = this.y * f3 - f2 * this.z;
        vec3D.y = this.z * f - f3 * this.x;
        vec3D.z = this.x * f2 - f * this.y;
        return vec3D;
    }

    public final Vec3D crossSelf(Vec3D vec3D) {
        float f = this.y * vec3D.z - vec3D.y * this.z;
        float f2 = this.z * vec3D.x - vec3D.z * this.x;
        this.z = this.x * vec3D.y - vec3D.x * this.y;
        this.y = f2;
        this.x = f;
        return this;
    }

    @Override
    public final float distanceTo(ReadonlyVec3D readonlyVec3D) {
        if (readonlyVec3D != null) {
            float f = this.x - readonlyVec3D.x();
            float f2 = this.y - readonlyVec3D.y();
            float f3 = this.z - readonlyVec3D.z();
            return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        }
        return Float.NaN;
    }

    @Override
    public final float distanceToSquared(ReadonlyVec3D readonlyVec3D) {
        if (readonlyVec3D != null) {
            float f = this.x - readonlyVec3D.x();
            float f2 = this.y - readonlyVec3D.y();
            float f3 = this.z - readonlyVec3D.z();
            return f * f + f2 * f2 + f3 * f3;
        }
        return Float.NaN;
    }

    @Override
    public final float dot(ReadonlyVec3D readonlyVec3D) {
        return this.x * readonlyVec3D.x() + this.y * readonlyVec3D.y() + this.z * readonlyVec3D.z();
    }

    public final float dot(Vec3D vec3D) {
        return this.x * vec3D.x + this.y * vec3D.y + this.z * vec3D.z;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ReadonlyVec3D) {
            ReadonlyVec3D readonlyVec3D = (ReadonlyVec3D)object;
            return this.x == readonlyVec3D.x() && this.y == readonlyVec3D.y() && this.z == readonlyVec3D.z();
        }
        return false;
    }

    @Override
    public boolean equalsWithTolerance(ReadonlyVec3D readonlyVec3D, float f) {
        return MathUtils.abs(this.x - readonlyVec3D.x()) < f && MathUtils.abs(this.y - readonlyVec3D.y()) < f && MathUtils.abs(this.z - readonlyVec3D.z()) < f;
    }

    public final Vec3D floor() {
        this.x = MathUtils.floor(this.x);
        this.y = MathUtils.floor(this.y);
        this.z = MathUtils.floor(this.z);
        return this;
    }

    public final Vec3D frac() {
        this.x -= (float)MathUtils.floor(this.x);
        this.y -= (float)MathUtils.floor(this.y);
        this.z -= (float)MathUtils.floor(this.z);
        return this;
    }

    @Override
    public final Vec3D getAbs() {
        return new Vec3D(this).abs();
    }

    @Override
    public final float getComponent(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final float getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index must be 0, 1 or 2");
    }

    @Override
    public final Vec3D getConstrained(AABB aABB) {
        return new Vec3D(this).constrain(aABB);
    }

    @Override
    public final Vec3D getFloored() {
        return new Vec3D(this).floor();
    }

    @Override
    public final Vec3D getFrac() {
        return new Vec3D(this).frac();
    }

    @Override
    public final Vec3D getInverted() {
        return new Vec3D(-this.x, -this.y, -this.z);
    }

    @Override
    public final Vec3D getLimited(float f) {
        if (this.magSquared() > f * f) {
            return this.getNormalizedTo(f);
        }
        return new Vec3D(this);
    }

    @Override
    public final Vec3D getNormalized() {
        return new Vec3D(this).normalize();
    }

    @Override
    public final Vec3D getNormalizedTo(float f) {
        return new Vec3D(this).normalizeTo(f);
    }

    @Override
    public final Vec3D getReciprocal() {
        return this.copy().reciprocal();
    }

    @Override
    public final Vec3D getReflected(ReadonlyVec3D readonlyVec3D) {
        return this.copy().reflect(readonlyVec3D);
    }

    @Override
    public final Vec3D getRotatedAroundAxis(ReadonlyVec3D readonlyVec3D, float f) {
        return new Vec3D(this).rotateAroundAxis(readonlyVec3D, f);
    }

    @Override
    public final Vec3D getRotatedX(float f) {
        return new Vec3D(this).rotateX(f);
    }

    @Override
    public final Vec3D getRotatedY(float f) {
        return new Vec3D(this).rotateY(f);
    }

    @Override
    public final Vec3D getRotatedZ(float f) {
        return new Vec3D(this).rotateZ(f);
    }

    @Override
    public final Vec3D getSignum() {
        return new Vec3D(this).signum();
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.x);
        n += 37 * n + Float.floatToIntBits(this.y);
        n += 37 * n + Float.floatToIntBits(this.z);
        return n;
    }

    @Override
    public final float headingXY() {
        return (float)Math.atan2(this.y, this.x);
    }

    @Override
    public final float headingXZ() {
        return (float)Math.atan2(this.z, this.x);
    }

    @Override
    public final float headingYZ() {
        return (float)Math.atan2(this.y, this.z);
    }

    public ReadonlyVec3D immutable() {
        return this;
    }

    @Override
    public final Vec3D interpolateTo(ReadonlyVec3D readonlyVec3D, float f) {
        return new Vec3D(this.x + (readonlyVec3D.x() - this.x) * f, this.y + (readonlyVec3D.y() - this.y) * f, this.z + (readonlyVec3D.z() - this.z) * f);
    }

    @Override
    public final Vec3D interpolateTo(ReadonlyVec3D readonlyVec3D, float f, InterpolateStrategy interpolateStrategy) {
        return new Vec3D(interpolateStrategy.interpolate(this.x, readonlyVec3D.x(), f), interpolateStrategy.interpolate(this.y, readonlyVec3D.y(), f), interpolateStrategy.interpolate(this.z, readonlyVec3D.z(), f));
    }

    public final Vec3D interpolateTo(Vec3D vec3D, float f) {
        return new Vec3D(this.x + (vec3D.x - this.x) * f, this.y + (vec3D.y - this.y) * f, this.z + (vec3D.z - this.z) * f);
    }

    public final Vec3D interpolateTo(Vec3D vec3D, float f, InterpolateStrategy interpolateStrategy) {
        return new Vec3D(interpolateStrategy.interpolate(this.x, vec3D.x, f), interpolateStrategy.interpolate(this.y, vec3D.y, f), interpolateStrategy.interpolate(this.z, vec3D.z, f));
    }

    public final Vec3D interpolateToSelf(ReadonlyVec3D readonlyVec3D, float f) {
        this.x += (readonlyVec3D.x() - this.x) * f;
        this.y += (readonlyVec3D.y() - this.y) * f;
        this.z += (readonlyVec3D.z() - this.z) * f;
        return this;
    }

    public final Vec3D interpolateToSelf(ReadonlyVec3D readonlyVec3D, float f, InterpolateStrategy interpolateStrategy) {
        this.x = interpolateStrategy.interpolate(this.x, readonlyVec3D.x(), f);
        this.y = interpolateStrategy.interpolate(this.y, readonlyVec3D.y(), f);
        this.z = interpolateStrategy.interpolate(this.z, readonlyVec3D.z(), f);
        return this;
    }

    public final Vec3D invert() {
        this.x *= -1.0f;
        this.y *= -1.0f;
        this.z *= -1.0f;
        return this;
    }

    @Override
    public boolean isInAABB(AABB aABB) {
        Vec3D vec3D = aABB.getMin();
        Vec3D vec3D2 = aABB.getMax();
        if (this.x < vec3D.x || this.x > vec3D2.x) {
            return false;
        }
        if (this.y < vec3D.y || this.y > vec3D2.y) {
            return false;
        }
        return !(this.z < vec3D.z) && !(this.z > vec3D2.z);
    }

    @Override
    public boolean isInAABB(Vec3D vec3D, Vec3D vec3D2) {
        float f = vec3D2.x;
        if (this.x < vec3D.x - f || this.x > vec3D.x + f) {
            return false;
        }
        f = vec3D2.y;
        if (this.y < vec3D.y - f || this.y > vec3D.y + f) {
            return false;
        }
        f = vec3D2.z;
        return !(this.z < vec3D.z - f) && !(this.z > vec3D.z + f);
    }

    @Override
    public final boolean isMajorAxis(float f) {
        float f2 = MathUtils.abs(this.x);
        float f3 = MathUtils.abs(this.y);
        float f4 = MathUtils.abs(this.z);
        float f5 = 1.0f - f;
        if (f2 > f5) {
            if (f3 < f) {
                return f4 < f;
            }
        } else if (f3 > f5) {
            if (f2 < f) {
                return f4 < f;
            }
        } else if (f4 > f5 && f2 < f) {
            return f3 < f;
        }
        return false;
    }

    @Override
    public final boolean isZeroVector() {
        return MathUtils.abs(this.x) < 1.1920929E-7f && MathUtils.abs(this.y) < 1.1920929E-7f && MathUtils.abs(this.z) < 1.1920929E-7f;
    }

    public final Vec3D jitter(float f) {
        return this.jitter(f, f, f);
    }

    public final Vec3D jitter(float f, float f2, float f3) {
        this.x += MathUtils.normalizedRandom() * f;
        this.y += MathUtils.normalizedRandom() * f2;
        this.z += MathUtils.normalizedRandom() * f3;
        return this;
    }

    public final Vec3D jitter(Random random, float f) {
        return this.jitter(random, f, f, f);
    }

    public final Vec3D jitter(Random random, float f, float f2, float f3) {
        this.x += MathUtils.normalizedRandom(random) * f;
        this.y += MathUtils.normalizedRandom(random) * f2;
        this.z += MathUtils.normalizedRandom(random) * f3;
        return this;
    }

    public final Vec3D jitter(Random random, Vec3D vec3D) {
        return this.jitter(random, vec3D.x, vec3D.y, vec3D.z);
    }

    public final Vec3D jitter(Vec3D vec3D) {
        return this.jitter(vec3D.x, vec3D.y, vec3D.z);
    }

    public final Vec3D limit(float f) {
        if (this.magSquared() > f * f) {
            return this.normalize().scaleSelf(f);
        }
        return this;
    }

    @Override
    public final float magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public final float magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final Vec3D maxSelf(ReadonlyVec3D readonlyVec3D) {
        this.x = MathUtils.max(this.x, readonlyVec3D.x());
        this.y = MathUtils.max(this.y, readonlyVec3D.y());
        this.z = MathUtils.max(this.z, readonlyVec3D.z());
        return this;
    }

    public final Vec3D minSelf(ReadonlyVec3D readonlyVec3D) {
        this.x = MathUtils.min(this.x, readonlyVec3D.x());
        this.y = MathUtils.min(this.y, readonlyVec3D.y());
        this.z = MathUtils.min(this.z, readonlyVec3D.z());
        return this;
    }

    public final Vec3D modSelf(float f) {
        this.x %= f;
        this.y %= f;
        this.z %= f;
        return this;
    }

    public final Vec3D modSelf(float f, float f2, float f3) {
        this.x %= f;
        this.y %= f2;
        this.z %= f3;
        return this;
    }

    public final Vec3D normalize() {
        float f = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (f > 0.0f) {
            f = 1.0f / f;
            this.x *= f;
            this.y *= f;
            this.z *= f;
        }
        return this;
    }

    public final Vec3D normalizeTo(float f) {
        float f2 = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (f2 > 0.0f) {
            f2 = f / f2;
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
        }
        return this;
    }

    public final Vec3D reciprocal() {
        this.x = 1.0f / this.x;
        this.y = 1.0f / this.y;
        this.z = 1.0f / this.z;
        return this;
    }

    public final Vec3D reflect(ReadonlyVec3D readonlyVec3D) {
        return this.set(readonlyVec3D.scale(this.dot(readonlyVec3D) * 2.0f).subSelf(this));
    }

    public final Vec3D rotateAroundAxis(ReadonlyVec3D readonlyVec3D, float f) {
        float f2 = readonlyVec3D.x();
        float f3 = readonlyVec3D.y();
        float f4 = readonlyVec3D.z();
        float f5 = f2 * this.x;
        float f6 = f2 * this.y;
        float f7 = f2 * this.z;
        float f8 = f3 * this.x;
        float f9 = f3 * this.y;
        float f10 = f3 * this.z;
        float f11 = f4 * this.x;
        float f12 = f4 * this.y;
        float f13 = f4 * this.z;
        double d = Math.sin(f);
        double d2 = Math.cos(f);
        float f14 = (float)((double)(f2 * (f5 + f9 + f13)) + (double)(this.x * (f3 * f3 + f4 * f4) - f2 * (f9 + f13)) * d2 + (double)(-f12 + f10) * d);
        float f15 = (float)((double)(f3 * (f5 + f9 + f13)) + (double)(this.y * (f2 * f2 + f4 * f4) - f3 * (f5 + f13)) * d2 + (double)(f11 - f7) * d);
        float f16 = (float)((double)(f4 * (f5 + f9 + f13)) + (double)(this.z * (f2 * f2 + f3 * f3) - f4 * (f5 + f9)) * d2 + (double)(-f8 + f6) * d);
        this.x = f14;
        this.y = f15;
        this.z = f16;
        return this;
    }

    public final Vec3D rotateX(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = f2 * this.z - f3 * this.y;
        this.y = f3 * this.z + f2 * this.y;
        this.z = f4;
        return this;
    }

    public final Vec3D rotateY(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = f2 * this.x - f3 * this.z;
        this.z = f3 * this.x + f2 * this.z;
        this.x = f4;
        return this;
    }

    public final Vec3D rotateZ(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = f2 * this.x - f3 * this.y;
        this.y = f3 * this.x + f2 * this.y;
        this.x = f4;
        return this;
    }

    public final Vec3D roundToAxis() {
        if (MathUtils.abs(this.x) < 0.5f) {
            this.x = 0.0f;
        } else {
            this.x = this.x < 0.0f ? -1.0f : 1.0f;
            this.z = 0.0f;
            this.y = 0.0f;
        }
        if (MathUtils.abs(this.y) < 0.5f) {
            this.y = 0.0f;
        } else {
            this.y = this.y < 0.0f ? -1.0f : 1.0f;
            this.z = 0.0f;
            this.x = 0.0f;
        }
        if (MathUtils.abs(this.z) < 0.5f) {
            this.z = 0.0f;
        } else {
            this.z = this.z < 0.0f ? -1.0f : 1.0f;
            this.y = 0.0f;
            this.x = 0.0f;
        }
        return this;
    }

    @Override
    public Vec3D scale(float f) {
        return new Vec3D(this.x * f, this.y * f, this.z * f);
    }

    @Override
    public Vec3D scale(float f, float f2, float f3) {
        return new Vec3D(this.x * f, this.y * f2, this.z * f3);
    }

    @Override
    public Vec3D scale(ReadonlyVec3D readonlyVec3D) {
        return new Vec3D(this.x * readonlyVec3D.x(), this.y * readonlyVec3D.y(), this.z * readonlyVec3D.z());
    }

    public Vec3D scale(Vec3D vec3D) {
        return new Vec3D(this.x * vec3D.x, this.y * vec3D.y, this.z * vec3D.z);
    }

    public Vec3D scaleSelf(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vec3D scaleSelf(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        return this;
    }

    public Vec3D scaleSelf(Vec3D vec3D) {
        this.x *= vec3D.x;
        this.y *= vec3D.y;
        this.z *= vec3D.z;
        return this;
    }

    public Vec3D set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vec3D set(ReadonlyVec3D readonlyVec3D) {
        this.x = readonlyVec3D.x();
        this.y = readonlyVec3D.y();
        this.z = readonlyVec3D.z();
        return this;
    }

    public Vec3D set(Vec3D vec3D) {
        this.x = vec3D.x;
        this.y = vec3D.y;
        this.z = vec3D.z;
        return this;
    }

    public final Vec3D setComponent(Axis axis, float f) {
        switch (axis) {
            case X: {
                this.x = f;
                break;
            }
            case Y: {
                this.y = f;
                break;
            }
            case Z: {
                this.z = f;
            }
        }
        return this;
    }

    public final Vec3D setComponent(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
            }
        }
        return this;
    }

    public Vec3D setXY(Vec2D vec2D) {
        this.x = vec2D.x;
        this.y = vec2D.y;
        return this;
    }

    public Vec3D shuffle(int n) {
        block5: for (int i = 0; i < n; ++i) {
            switch (MathUtils.random(3)) {
                case 0: {
                    float f = this.x;
                    this.x = this.y;
                    this.y = f;
                    continue block5;
                }
                case 1: {
                    float f = this.x;
                    this.x = this.z;
                    this.z = f;
                    continue block5;
                }
                case 2: {
                    float f = this.y;
                    this.y = this.z;
                    this.z = f;
                }
            }
        }
        return this;
    }

    public Vec3D signum() {
        this.x = this.x < 0.0f ? -1 : (this.x == 0.0f ? 0 : 1);
        this.y = this.y < 0.0f ? -1 : (this.y == 0.0f ? 0 : 1);
        this.z = this.z < 0.0f ? -1 : (this.z == 0.0f ? 0 : 1);
        return this;
    }

    @Override
    public final Vec3D sub(float f, float f2, float f3) {
        return new Vec3D(this.x - f, this.y - f2, this.z - f3);
    }

    @Override
    public final Vec3D sub(ReadonlyVec3D readonlyVec3D) {
        return new Vec3D(this.x - readonlyVec3D.x(), this.y - readonlyVec3D.y(), this.z - readonlyVec3D.z());
    }

    public final Vec3D sub(Vec3D vec3D) {
        return new Vec3D(this.x - vec3D.x, this.y - vec3D.y, this.z - vec3D.z);
    }

    public final Vec3D subSelf(float f, float f2, float f3) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        return this;
    }

    public final Vec3D subSelf(Vec3D vec3D) {
        this.x -= vec3D.x;
        this.y -= vec3D.y;
        this.z -= vec3D.z;
        return this;
    }

    @Override
    public final Vec2D to2DXY() {
        return new Vec2D(this.x, this.y);
    }

    @Override
    public final Vec2D to2DXZ() {
        return new Vec2D(this.x, this.z);
    }

    @Override
    public final Vec2D to2DYZ() {
        return new Vec2D(this.y, this.z);
    }

    @Override
    public float[] toArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public float[] toArray4(float f) {
        return new float[]{this.x, this.y, this.z, f};
    }

    @Override
    public final Vec3D toCartesian() {
        float f = (float)((double)this.x * Math.cos(this.z));
        float f2 = (float)((double)f * Math.cos(this.y));
        float f3 = (float)((double)this.x * Math.sin(this.z));
        float f4 = (float)((double)f * Math.sin(this.y));
        this.x = f2;
        this.y = f3;
        this.z = f4;
        return this;
    }

    @Override
    public final Vec3D toSpherical() {
        float f = Math.abs(this.x) <= 1.1920929E-7f ? 1.1920929E-7f : this.x;
        float f2 = this.z;
        float f3 = (float)Math.sqrt(f * f + this.y * this.y + f2 * f2);
        this.z = (float)Math.asin(this.y / f3);
        this.y = (float)Math.atan(f2 / f) + ((double)f < 0.0 ? (float)Math.PI : 0.0f);
        this.x = f3;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(48);
        stringBuffer.append("{x:").append(this.x).append(", y:").append(this.y).append(", z:").append(this.z).append("}");
        return stringBuffer.toString();
    }

    @Override
    public final float x() {
        return this.x;
    }

    @Override
    public final float y() {
        return this.y;
    }

    @Override
    public final float z() {
        return this.z;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X(X_AXIS),
        Y(Y_AXIS),
        Z(Z_AXIS);

        private final ReadonlyVec3D vector;

        private Axis(ReadonlyVec3D readonlyVec3D) {
            this.vector = readonlyVec3D;
        }

        public ReadonlyVec3D getVector() {
            return this.vector;
        }
    }
}

