/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;
import ddf.minim.ugens.Frequency;
import ddf.minim.ugens.Waveform;
import ddf.minim.ugens.Waves;
import java.util.Arrays;

public class Oscil
extends UGen {
    public UGen.UGenInput amplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput frequency;
    public UGen.UGenInput phase;
    public UGen.UGenInput offset;
    private Waveform wave;
    private float step;
    private float stepSize;
    private float prevFreq;
    private float oneOverSampleRate;

    public Oscil(float f, float f2, Waveform waveform) {
        this(Frequency.ofHertz(f), f2, waveform);
    }

    public Oscil(float f, float f2) {
        this(Frequency.ofHertz(f), f2);
    }

    public Oscil(Frequency frequency, float f) {
        this(frequency, f, (Waveform)Waves.SINE);
    }

    public Oscil(Frequency frequency, float f, Waveform waveform) {
        this.amplitude.setLastValue(f);
        this.frequency = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.frequency.setLastValue(frequency.asHz());
        this.phase = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.phase.setLastValue(0.0f);
        this.offset = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.offset.setLastValue(0.0f);
        this.wave = waveform;
        this.step = 0.0f;
        this.oneOverSampleRate = 1.0f;
    }

    @Override
    protected void sampleRateChanged() {
        this.oneOverSampleRate = 1.0f / this.sampleRate();
        this.stepSize = this.frequency.getLastValue() * this.oneOverSampleRate;
        this.prevFreq = this.frequency.getLastValue();
    }

    private void updateStepSize() {
        float f = this.frequency.getLastValue();
        if (this.prevFreq != f) {
            this.stepSize = f * this.oneOverSampleRate;
            this.prevFreq = f;
        }
    }

    public void setFrequency(float f) {
        this.frequency.setLastValue(f);
        this.updateStepSize();
    }

    public void setFrequency(Frequency frequency) {
        this.frequency.setLastValue(frequency.asHz());
        this.updateStepSize();
    }

    public void setAmplitude(float f) {
        this.amplitude.setLastValue(f);
    }

    public void setPhase(float f) {
        this.phase.setLastValue(f);
    }

    public void setWaveform(Waveform waveform) {
        this.wave = waveform;
    }

    public Waveform getWaveform() {
        return this.wave;
    }

    public void reset() {
        this.step = this.phase.getLastValue();
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float f = this.amplitude.getLastValue();
        float f2 = this.step + this.phase.getLastValue();
        if (f2 < 0.0f) {
            f2 -= (float)((int)f2) - 1.0f;
        }
        if (f2 > 1.0f) {
            f2 -= (float)((int)f2);
        }
        float f3 = f * this.wave.value(f2) + this.offset.getLastValue();
        Arrays.fill(fArray, f3);
        this.updateStepSize();
        this.step += this.stepSize;
        if (this.step < 0.0f) {
            this.step -= (float)((int)this.step) - 1.0f;
        }
        if (this.step > 1.0f) {
            this.step -= (float)((int)this.step);
        }
    }
}

