//note its using filecache
//don't forget to delete the file
//if you need to generate a new 
//look up table
#define USE_FILE_CACHE
#include "TmdcGfx.h"
#include "ConsoleScreen.h"
#ifdef USE_FILE_CACHE
#include <stdio.h>
#endif

//here you can change the character for the big lookup table
//cgrad contains the caracters
//vgrad contains how white the character is 0=black 255=white
//for example the L character is 96, less than half of it are
//black pixels
//const unsigned char num_of_glyphs = 7;
//const unsigned char cgrad[]={250,249,  7,254,  4,  3,177};
//const unsigned char vgrad[]={  8, 16, 48, 64,100,130,128};
const unsigned char num_of_glyphs = 16;
const unsigned char cgrad[]={176,177, 64, 65, 67, 68, 'I', 'L','i','|','.',':',';','=','>',250};
const unsigned char vgrad[]={64,128 ,131,112, 88,128,  72, 96, 60,48  ,16,32,44,48,56,     8};

ConsoleScreen Con; //well...

class color
{
public: 
	int r,g,b;
};

inline color operator +(color a,color b)
{a.r=a.r+b.r; a.g=a.g+b.g; a.b=a.b+b.b; return a;}

inline color operator -(color a)
{ a.r=-a.r; a.g=-a.g; a.b=-a.b; return a;}

inline color operator -(color a,color b)
{a= a+(-b); return a;}

inline int iabs(int a){if (a<0) return -a; else return a;}
inline int operator ~(color a)
{return iabs(a.r)+iabs(a.g)+iabs(a.b);}

inline color operator !(color a)
{
	if (a.r>255) a.r=255; else if (a.r<0) a.r=0;
	if (a.g>255) a.g=255; else if (a.g<0) a.g=0;
	if (a.b>255) a.b=255; else if (a.b<0) a.b=0;
	return a;
}
inline color operator *(color a,color b)
{
	a.r=(a.r*b.r)>>8;
	a.g=(a.g*b.g)>>8;
	a.b=(a.b*b.b)>>8;
	return a;
}
inline color operator *(int a,color b)
{b.r=(b.r*a)>>8;b.g=(b.g*a)>>8;b.b=(b.b*a)>>8;return b;}
inline color operator *(color b,int a)
{return a*b;}

const color palette[16]=
{{	000,	000,	000},{	000,	000,	128},{	000,	128,	000},{	000,	128,	128},
{	128,	000,	000},{	128,	000,	128},{	128,	128,	000},{	192,	192,	192},
{	128,	128,	128},{	000,	000,	255},{	000,	255,	000},{	000,	255,	255},
{	255,	000,	000},{	255,	000,	255},{	255,	255,	000},{	255,	255,	255}};

class tcharinfo
{
public:
	char character,attribute,bgcolor,fgcolor;
	color mixcolor;
	tcharinfo(){character=attribute=bgcolor=fgcolor=0; mixcolor.r=mixcolor.g=mixcolor.b=0;}
};

tcharinfo biglut[16][16][16];
char lut[5][5][5];

void calc_biglut()
{
	#ifdef USE_FILE_CACHE
	FILE *infile = fopen("lut.bin","rb");
	bool bWasRead=false;
	if (infile!=NULL)
	{
		for (int i0=0; i0<16; i0++)
		for (int i1=0; i1<16; i1++)
		for (int i2=0; i2<16; i2++)
		{
			fread(&(biglut[i0][i1][i2]),sizeof(tcharinfo),1,infile);
		}
		fclose(infile);
		bWasRead=true;
	}
	else
	#endif
	for (int r=0; r<16; r++)
	for (int g=0; g<16; g++)
	for (int b=0; b<16; b++)
	{
		tcharinfo best;
		int bestdelta=99999;
		color thiscolor;
		thiscolor.r=(r<<4)+r;
		thiscolor.g=(g<<4)+r;
		thiscolor.b=(b<<4)+r;

		for (int bg=0; bg<16; bg++)
		for (int fg=0; fg<16; fg++)
		{
			#define test(A,B) ((bg==A) && (fg ==B)) || ((bg==B) && (fg ==A))
			#define qtst(A,B) if (test(A,B)) continue
			qtst(0,15); qtst(0,14); qtst(0,13); qtst(0,12);
			qtst(0,11); qtst(0,10); qtst(0,9); qtst(0,7);
			qtst(1,15); qtst(2,15); qtst(3,15); qtst(4,15);
			qtst(5,15); qtst(6,15); qtst(8,15); 
			qtst(1,6); qtst(2,5); qtst(3,4);
			qtst(1,14); qtst(2,13); qtst(3,12);
			qtst(9,6); qtst(10,5); qtst(11,4);
			qtst(9,14); qtst(10,13); qtst(11,12);
			#undef qtst
			#undef test
			for (int icg=0; icg<num_of_glyphs; icg++)
			{
				tcharinfo current;
				int currentdelta;

				current.character=cgrad[icg];
				current.attribute=(fg<<4)+bg;
				current.bgcolor=bg;
				current.fgcolor=fg;
				current.mixcolor=palette[bg]*(255-vgrad[icg])+palette[fg]*vgrad[icg];

				currentdelta=~(current.mixcolor-thiscolor);
					//+((min(~(palette[bg]*( min(vgrad[icg],255-vgrad[icg]) )),~(palette[fg]*( min(vgrad[icg],255-vgrad[icg]) )))>>0));
			
				if (currentdelta<bestdelta)
				{
					best=current;
					bestdelta=currentdelta;
				}
			}
		}

		biglut[r][g][b]=best;
	}
	#ifdef USE_FILE_CACHE
	if (!bWasRead)
	{
		FILE *outfile = fopen("lut.bin","wb");
	
		if (outfile!=NULL)
		{
			for (int i0=0; i0<16; i0++)
			for (int i1=0; i1<16; i1++)
			for (int i2=0; i2<16; i2++)
			{
				fwrite(&(biglut[i0][i1][i2]),sizeof(tcharinfo),1,outfile);
			}
			fclose(outfile);
		}
	}
	#endif
}

void calc_lut()
{
	int mindc,mindci;
	int dc;

	for (int r=0; r<5; r++)
	for (int g=0; g<5; g++)
	for (int b=0; b<5; b++)
	{
		color c={r<<6,g<<6,b<<6};
		mindc=999;
		mindci=0;
		for (int i=0; i<16; i++)
		{
			dc=~(palette[i]-c);
			if (dc<mindc)
			{
				mindc=dc;
				mindci=i;
			}
		}
		lut[r][g][b]=mindci;
	}
}

void c_conv(int in_red,int in_green, int in_blue, int &c_f, int &c_b, int &chr, int &rerr, int &gerr, int &berr)
{
	/*color a={in_red,in_green,in_blue},b,c,d;
	b=!a; b.r=(b.r+32)>>6; b.g=(b.g+32)>>6; b.b=(b.b+32)>>6;
	c=palette[lut[b.r][b.g][b.b]];
	d=a+a-c;
	b=!d; b.r=(b.r+32)>>6; b.g=(b.g+32)>>6; b.b=(b.b+32)>>6;
	d=palette[lut[b.r][b.g][b.b]];

	int d1 = ~(a-c), d2 = ~(a-d);
	*/

	//int qqq=Gfx.GetColor();
	
	color ca,cb;
	
	in_red=in_red&255;
	in_green=in_green&255;
	in_blue=in_blue&255;

	ca.r=in_red;ca.g=in_green;ca.b=in_blue;

	cb=ca;
	ca=!ca; ca.r=(ca.r+32)>>6; ca.g=(ca.g+32)>>6; ca.b=(ca.b+32)>>6;
	c_f=lut[ca.r][ca.g][ca.b];
	ca=cb+cb-palette[c_f];
	ca=!ca; ca.r=(ca.r+32)>>6; ca.g=(ca.g+32)>>6; ca.b=(ca.b+32)>>6;
	
	c_b = lut[ca.r][ca.g][ca.b];

	static char z;
	chr = "GOAT"[z++&3];

	rerr = in_red;
	rerr =((palette[c_f].r + palette[c_b].r)>>3)-(rerr>>2);
	gerr = in_green;
	gerr =((palette[c_f].g + palette[c_b].g)>>3)-(gerr>>2);
	berr = in_blue;
	berr =((palette[c_f].b + palette[c_b].b)>>3)-(berr>>2);
}

void c_conv_big(int in_red,int in_green, int in_blue, int &c_f, int &c_b, int &chr, int &rerr, int &gerr, int &berr)
{
	color ca,cb;
	
	in_red=in_red&255;
	in_green=in_green&255;
	in_blue=in_blue&255;

	ca.r=in_red;ca.g=in_green;ca.b=in_blue;

	ca=!ca; ca.r=(ca.r)>>4; ca.g=(ca.g)>>4; ca.b=(ca.b)>>4;	
	
	c_f=biglut[ca.r][ca.g][ca.b].bgcolor; //lol switch
	c_b=biglut[ca.r][ca.g][ca.b].fgcolor;
	chr=biglut[ca.r][ca.g][ca.b].character;
	
	ca=biglut[ca.r][ca.g][ca.b].mixcolor;


	rerr = (ca.r)-(in_red);
	gerr = (ca.g)-(in_green);
	berr = (ca.b)-(in_blue);
}

void TmdcGfx::ColorConverter(int in_red,int in_green, int in_blue, int &c_f, int &c_b, int &chr, bool dither)
{
	static int rerror=0,gerror=0,berror=0;
	if (dither)
	{
		in_red=in_red&255;
		in_green=in_green&255;
		in_blue=in_blue&255;

		in_red-=rerror; if (in_red>255) in_red=255; else if (in_red<0) in_red=0;
		in_green-=gerror; if (in_green>255) in_green=255; else if (in_green<0) in_green=0;
		in_blue-=berror;if (in_blue>255) in_blue=255; else if (in_blue<0) in_blue=0;
	}
	else rerror=gerror=berror=0;
	c_conv_big(in_red,in_green,in_blue,c_f,c_b,chr,rerror,gerror,berror);
}

void TmdcGfx::Init()
{
	c_sharpen=0.5;
	calc_lut();
	calc_biglut();
	bAntiAlias=true; 
	bDither=true;
    //c_brightness=c_contrast=c_r_bot=c_r_mid=c_r_top=c_g_bot=c_g_mid=c_g_top=c_b_bot=c_b_mid=c_b_top=c_sharpen=0;
    SetBrighten(0); SetDarken(0);
	SetRed(0,0,0,0,0);
	SetGreen(0,0,0,0,0);
	SetBlue(0,0,0,0,0);
}

void TmdcGfx::DoBuildIntermediate()
{
	int *src = this->buffer;
	int *dst = this->Frame32;

	if (bAntiAlias)
	{
		int v_r=0,v_g=0,v_b=0,vvv=0;

		for (int y=0; y<50; y++)
		{
			for (int x=0; x<80; x++)
			{
				

				for (int v=0; v<4; v++)
				for (int u=0; u<4; u++)
				{
					vvv=this->GetPixel((x<<2)+u,(y<<2)+v);
					v_r+=(vvv>>16)&255;
					v_g+=(vvv>>8)&255;
					v_b+=vvv&255;
				}
				v_r=(v_r>>4);
				v_g=(v_g>>4);
				v_b=(v_b>>4);

				//dunno why...
				if (v_r>255) v_r=255;
				if (v_g>255) v_g=255;
				if (v_b>255) v_b=255; 

				vvv=(v_r<<16)+(v_g<<8)+v_b;
				
				*dst=vvv;
				dst++;
			}
		}
	}
	else
	{
		for (int y=0; y<50; y++)
		{

			for (int x=0; x<80; x++)
			{
				*dst=*src;
				src+=4;
				dst++;
			}
			src+=240*4;
			
		}
	}
}

unsigned char fbs[80*50*4];

void TmdcGfx::DoPostProcess()
{
	unsigned char* fb = (unsigned char*)Frame32;
	memcpy(fbs,fb,80*50*4);

	for (int y=1; y<49; y++)
	for (int x=1; x<79*4; x++)
	{
		int nc=fbs[x+y*320]*5-fbs[x+y*320-4]-fbs[x+y*320+4]-fbs[x+y*320-320]-fbs[x+y*320+320];
		if (nc>255) nc=255; else if (nc<0) nc=0;
		fb[x+y*320]=(nc*c_sharpen + fb[x+y*320]*(1-c_sharpen));
	}

	for (int q=0; q<80*50*4; q++)
	{
		fb[q]=curve_table[q&3][fb[q]];
	}
}

float CubicInterpolate(float y0,float y1,float y2,float y3,float mu)
{
   float a0,a1,a2,a3,mu2;

   mu2 = mu*mu;
   a0 = y3 - y2 - y0 + y1;
   a1 = y0 - y1 - a0;
   a2 = y2 - y0;
   a3 = y1;

   return(a0*mu*mu2+a1*mu2+a2*mu+a3);
}

void TmdcGfx::CalcCurves()
{
	bCurveChange=false;
	for (int i=1; i<255; i++)
	{
		float proc=i/255.0*5.0;
		int p1=proc;
		proc=proc-p1;
		p1++;

		curve_table[2][i]=-c_darken+c_brighten*CubicInterpolate(c_r[p1-1],c_r[p1],c_r[p1+1],c_r[p1+2],proc);
		curve_table[1][i]=-c_darken+c_brighten*CubicInterpolate(c_g[p1-1],c_g[p1],c_g[p1+1],c_g[p1+2],proc);
		curve_table[0][i]=-c_darken+c_brighten*CubicInterpolate(c_b[p1-1],c_b[p1],c_b[p1+1],c_b[p1+2],proc);
	}

	curve_table[2][0]=c_r[1];
	curve_table[1][0]=c_g[1];
	curve_table[0][0]=c_b[1];

	curve_table[2][255]=c_r[5];
	curve_table[1][255]=c_g[5];
	curve_table[0][255]=c_b[5];

	for (int j=0; j<4; j++)
	for (int i=0; i<256; i++)
	{
		if (curve_table[j][i]<0) curve_table[j][i]=0; 
		else if (curve_table[j][i]>255) curve_table[j][i]=255; 
	}

}

void TmdcGfx::SetRed(float a,float b, float c, float d,float e)
{
	bCurveChange=true;
	c_r[0]=( -1.25/5.0)*255;
	c_r[1]=(a+0.00/5.0)*255;
	c_r[2]=(b+1.25/5.0)*255;
	c_r[3]=(c+2.50/5.0)*255;
	c_r[4]=(d+4.75/5.0)*255;
	c_r[5]=(e+5.00/5.0)*255;
	c_r[6]=( +6.25/5.0)*255;
}

void TmdcGfx::SetGreen(float a,float b, float c, float d,float e)
{
	bCurveChange=true;
	c_g[0]=( -1.25/5.0)*255;
	c_g[1]=(a+0.00/5.0)*255;
	c_g[2]=(b+1.25/5.0)*255;
	c_g[3]=(c+2.50/5.0)*255;
	c_g[4]=(d+4.75/5.0)*255;
	c_g[5]=(e+5.00/5.0)*255;
	c_g[6]=( +6.25/5.0)*255;
}

void TmdcGfx::SetBlue(float a,float b, float c, float d,float e)
{
	bCurveChange=true;
	c_b[0]=( -1.25/5.0)*255;
	c_b[1]=(a+0.00/5.0)*255;
	c_b[2]=(b+1.25/5.0)*255;
	c_b[3]=(c+2.50/5.0)*255;
	c_b[4]=(d+4.75/5.0)*255;
	c_b[5]=(e+5.00/5.0)*255;
	c_b[6]=( +6.25/5.0)*255;
}

void TmdcGfx::DoConvertToText()
{
	if (bCurveChange)
	{
		CalcCurves();
	}

	int *src = this->Frame32;
	for (int y=0; y<50; y++)
	for (int x=0; x<80; x++)
	{
		int cf,cb,ch;
		//int safe = this->GetPixelTmdc(x,y);
		this->ColorConverter((*src)>>16,(*src)>>8,*src,cf,cb,ch,bDither);
		//this->ColorConverter((safe)>>16,(safe)>>8,safe,cf,cb,ch,bDither);
		Con.Put(x,y,ch,cb+(cf<<4));
		src++;
	}
}

void TmdcGfx::DoOutputToConsole()
{
	Con.Refresh();
}

void TmdcGfx::DoTheMagic()
{
	DoBuildIntermediate();
	DoPostProcess();
	DoConvertToText();
	DoOutputToConsole();
}

void TmdcGfx::SetConsoleWindowTitle(char* title)
{
	Con.SetTitle(title);
}

void TmdcGfx::PutCharConsole(char a,char b,char c,char d)
{
	Con.Put(a,b,c,d);
}
	
void* TmdcGfx::GetBufferConsole()
{
	return Con.GetBuffer();
}