#ifndef MYGFX_H
#define MYGFX_H
#define MyGraphics MyGfx

//this graphics class has it's own buffer and basic drawing methods
//you need to implement your own graphics methods,
//you can use these as a base
//WARNING! graphics functions are not safe, giving bag arguments will result in segfault
//canvas size is hardcoded to 320x200
//and it doesn't give any output methods, you need to implement these on your own
//ie you can subclass it and implement something like OutputToScreen() using win api;
class MyGfx
{
protected:
	int buffer[64000];
	int color;

public:

	MyGfx()
	{
		color=0x0;
		RectangleFilled(0,0,319,199);
		color=0xffffff;
	}

	void SetColor(int C=0xffffff){ color=C; }
	int  GetColor(){ return color; }
	void PutPixel(int x,int y){ buffer[x+(y<<6)+(y<<8)]=color; }
	int  GetPixel(int x,int y){ return buffer[x+(y<<6)+(y<<8)];}

	void Span(int x, int y, int w);
	void HLine(int x1, int y1, int x2, int y2=0);
	void VLine(int x1, int y1, int x2, int y2);
	void Rectangle(int x1,int y1, int x2, int y2);
	void RectangleFilled(int x1,int y1, int x2, int y2);
	void Line(int,int,int,int);

	void PutChar(int,int,char);
	void PutStr(int,int,char*);

	int* GetBuffer(){return buffer;}
};

#endif