
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include "TmdcGfx.h"


//this file contains the implementation of all graphics effects

int FXpzoomer_start = 0;
void FXpzoomer(TmdcGfx &gfx, bool nodecoration)
{
  //everyone uses clock() from time.h for timing
		//time is basically the only input information in a Gfx
    if (FXpzoomer_start == 0) FXpzoomer_start = clock();
		int tt=clock() - FXpzoomer_start; 

		//you are given a 320x200 32-bit framebuffer
		//it's like mode 13h but with more colors
		//you can access the memory directly using Gfx.GetBuffer()

		for (int y=0; y<200; y+=1) //for each line
		{
			//for my 3d rotozoomer I need to update transformation 
			//for every line
			int sy=y;
			y=y^0x03;
			int t = tt>>1 ;
			t+=(y&0x3)<<3; //motion blur :)
			t+=y;//that wierd warp effect
			
			//calculate
			float d=(y*(0.01)+0.5);
			float od=1/d;
			float zoom = (cos(t*0.0001)*cos(t*0.0002345+2.13245))*0.6+0.65;
      if (nodecoration) zoom *=2.0;
			float r=sin(t*0.0001)*sin(t*0.00027)*8;
			int a11 = (cos(r)*255*od)*zoom;
			int a12 = (sin(r)*255*od)*zoom;
			int a21 = -a12;
			int a22 = a11;
			int a31 = cos(t*0.00005345+4.21245)*255*1600*cos(t*0.00007345+2.13245);
			int a32 = sin(t*0.00002345+1.73245)*255*1600*sin(t*0.00003245+1.73245);

			//reset some variables I messed up
			t=tt>>4;
			y=sy;
			
			for (int x=0; x<320; x++) //for each pixel
			{				
				//apply transformations
				int	xx = ((x-160) * a11 + (y-120)*a12 +a31)>>8;
				int	yy = ((x-160) * a21 + (y-120)*a22 +a32)>>8;

				//this will improve precision
				xx = xx>>1;
				yy = yy>>1;
				//make sur I'm in that range
				xx = xx&0xffff;
				yy = yy&0xffff;
	
				//calculate the value for advanced xor texture
				//in tight loops use only integer math
				int c = (( xx^yy ^ 
					(((xx+421)>>2) + ((yy+321-(t>>8))>>1)) ^ 
					(((yy+71)>>3) + ((xx+93-(t>>8))>>2))) + (t>>4));
				
				//some more operations on the value
				c=(c&0x7f)+(c&0x10);

				//top and botto darken
        if (!nodecoration)
				 if (y>199-28 || y<28 ) c = (c>>2);

				//sets the pen color
				gfx.SetColor(c + (c<<16)+ (c<<8));
				//puts a pixel to the x,y coordinate
				//the function is unsafe, meaning the x and y MUST be in range
				//if you're not sure, check with an if
				gfx.PutPixel(x,y); 
				//these simple gfx routines are declared in MyGfx and only work on
				//its specific 320x200 32-bit buffer
			}
		}
}


const char bitmap_columns = 41;
const char bitmap[] =
{
	3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,3,3,3,0, 3,3,0,0,3,3,0,0,0,0,0,0,0,3,3,3,0,0,0,0, 0,
	3,1,1,1,1,1,3,3,3,3,3,3,3,0,3,3,3,1,3,3, 3,1,3,3,1,3,3,3,3,3,0,3,3,3,1,3,3,3,3,3, 0,
	3,3,3,1,3,3,2,1,1,2,3,1,3,3,1,3,1,1,1,3, 3,1,1,1,1,3,2,1,1,2,3,2,1,1,1,3,2,1,1,2, 3,
	0,0,3,1,3,3,1,1,1,1,3,3,1,2,3,3,3,1,3,3, 3,1,2,2,1,3,1,3,3,1,3,1,3,3,1,3,1,1,1,1, 3,
	0,0,3,1,3,3,1,3,3,3,3,3,2,1,3,3,3,1,3,3, 3,1,3,3,1,3,1,3,3,1,3,1,3,3,1,3,1,3,3,3, 3,
	0,0,3,1,3,3,2,1,1,3,3,1,3,3,1,3,3,2,1,3, 3,1,3,3,1,3,2,1,1,2,3,2,1,1,1,3,2,1,1,3, 0,
	0,0,3,3,3,0,3,3,3,0,3,3,0,0,3,3,0,3,3,0, 3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,0, 0
};
const int bpalette[] = { 0x00, 0xff, 0x2f, 0x00 };
void FXtitleBitmap(int x, int y, int s, TmdcGfx& gfx) // draw a small bitmap defined above
{
	for (int jj=0; jj<7<<s; jj++)
	for (int ii=0; ii<bitmap_columns<<s; ii++)
	{
		int i = ii>>s;
		int j = jj>>s;

		int color_index = bitmap[ j*bitmap_columns+i];
		if (color_index != 0) //first color is transparent
		{
			int r = (+sin(clock()*0.001-jj*0.3+ii*0.1)+1)*bpalette[color_index]*2;
			int g = (-sin(clock()*0.002+jj*0.2-ii*0.2)+1)*bpalette[color_index]*2;
			int b = (+sin(clock()*0.003-jj*0.1-ii*0.3)+1)*bpalette[color_index]*2;
			if (r>255) r=255;
			if (g>255) g=255;
			if (b>255) b=255;

			gfx.SetColor((r<<16)+(g<<8)+b);
			gfx.PutPixelTmdc(x+ii,y+jj);
			//if the gfx routine ends with Tmdc it means
			//that it's working with the buffer declared in TmdcGfx
			//in other words the intermediary 80x50 32-bit buffer
		}
	}
}

#include "scroller_message.h"
void FXtextScroller(int x, int y, TmdcGfx& gfx)
{
	for (int i=0; i<80; i++)
	{
		int q=i+x;
		if (q<0) continue; if (q>=scroller_message_lenght) continue;
		if (scroller_message[q]!=' ')
		gfx.PutCharConsole(i,y,scroller_message[q],0x0f);
	}
}


int FXfadeIn_start = 0;
void FXfadeIn(TmdcGfx &gfx)
{
  if (FXfadeIn_start == 0) FXfadeIn_start = clock();
  float t = (clock()-FXfadeIn_start)*0.001f;
  float amp = t*.02f;
  float s = (sin(t*.7)*.3+.5) + t*.1;
  if (amp>1.0f) amp = 1.0f;

  float r0 = 1.4;
  float g0 = .5;
  float b0 = .1;
  float r1 = .1;
  float g1 = .2;
  float b1 = .9;

  for (int y=0; y<200; y+=4)
  for (int x=0; x<320; x+=4)
  {
    float xx = (x-160)/160.0f;
    float yy = (y-100)/100.0f;
    xx *= s;
    xx += sin(t)*4.0;
    yy *= s;
    yy += sin(t*.5)*2.0;
    float value = sin ((sin(sin(yy*4)+xx*2) + sin(sin(xx*7)+yy*4))*4.0);
    int r = ((r0*y-r1*(200-y))/200.0*value*127+128)*amp;
    if (r<0) r=0; if(r>255) r= 255;
    int g = ((g0*y-g1*(200-y))/200.0*value*127+128)*amp;
    if (g<0) g=0; if(g>255) g= 255;
    int b = ((b0*y-b1*(200-y))/200.0*value*127+128)*amp;;
    if (b<0) b=0; if(b>255) b= 255;
    gfx.SetColor(r | (g<<8) | (b<<16));
    gfx.RectangleFilled(x,y,x+3,y+3);
  }

}

int FXintroMessage_start=0;
char* FXintroMessage_lmessage = 0;
void FXintroMessage(TmdcGfx &gfx,int sx, int sy, char* message, char attrib)
{
  if (FXintroMessage_lmessage != message) FXintroMessage_start = clock();
  FXintroMessage_lmessage = message;
  int t = (clock()-FXintroMessage_start)*.025;
  
  int x = sx;
  int y = sy;

  for (int i=0; i<strlen(message) && i < t; i++)
  {
    if (message[i] == '\n') { x = sx; y++; }
    else if (message[i] == ' ') {x++;}
    else
    {             
      gfx.PutCharConsole(x++,y,message[i],attrib);
    }
  }
}

int FXrectangles_start = 0;
int FXrectangles_start_frame = 0;
void FXrectangles(TmdcGfx &gfx,int row)
{
  row = row & 0xfffffffe;
  if (FXrectangles_start == 0) FXrectangles_start = clock();
  float t = (clock()-FXrectangles_start) * 0.001f;
  float s = cos(t*.5)*.3+.4;
  
  float cs = cos(t*t*t*.001f);
  float ss = sin(t*t*t*.001f);

  for (int y=FXrectangles_start_frame++&3; y<200; y+=4)
  for (int x=0; x<320; x+=2)
  {
    
    float xx1 = (x*s+y*s*.2); 
    float yy1 = (y*s-x*s*.2); 
    
    float xx = xx1*cs+yy1*ss;
    float yy = xx1*(-ss)+yy1*cs;

    yy+=64234;
    xx+=4124;
   
    xx += sin(t*.2)*100.0f/(t*.1+1.0f);
    yy += cos(t*.3)*100.0f/(t*.1+1.0f);

    int id = (xx-fmod(xx,16.0f))+(int(yy-fmod(yy,16.0f))<<8);
    
    float fr = sin(id*id*1429131.4123571f + row*.123 + t*.2)*.3+.3;
    if (fr<.0f) fr = .0f; fr = pow(fr,9.0f)*127.0*128.0;
    int r = fr;

    float fg = sin(id*id*194131.4234571f + row*.123 + t*.2)*.3+.3;
    if (fg<.0f) fg = .0f; fg = pow(fg,9.0f)*127.0*128.0;
    int g = fg;
  
    float fb = sin(id*id*262346.12354f + row*.123 + t*.2)*.3+.3;
    if (fb<.0f) fb = .0f; fb = pow(fb,9.0f)*127.0*128.0;
    int b = fb;

    r+=(g>>1);
    g+=(b>>1);
    b+=(r>>1);                             
    if (b<0) b=0; if (b>255) b = 255;    
    if (g<0) g=0; if (g>255) g = 255;  
    if (r<0) r=0; if (r>255) r = 255; 

    gfx.SetColor((r<<16)|(g<<8)|b);
    gfx.RectangleFilled(x,y,x+1,y);

  }

}

volatile char spheresf2(unsigned short x, unsigned short y, float t)
{                       
  float p[4];
  p[0]=p[1]=p[2]=p[3]=.0f;
  p[0]=400.0;
  p[1]=400.0;
  p[0]+=t*.02;   
  p[1]+=t*.2;
  p[2]=-2.0f + t;
  float td[4],d[4];
  td[0]=(x-160)*.01;
  td[1]=(y-100)*.01;
  td[2]=1.0;
  
  {
    float cs = cos(t*.1);
    float ss = sin(t*.1);
    d[0] = td[0]*cs + td[1]*ss;
    d[1] = td[0]*(-ss)+td[1]*cs;
    d[2] = td[2];
  }


  

  int i;
  for (i=0; i<15; i++)
  {
    float c[4];
    float four = 4.0f;
    float two = 2.0f;
    float dist;
    c[0]=fmod(p[0],4.0f);
    c[1]=fmod(p[1],4.0f);  
    c[2]=fmod(p[2],4.0f);
    _asm{
      fld four
      fld p[0]
      fprem         
      fstp c[0]         
      fld p[4]
      fprem         
      fstp c[4]
      fld p[8]
      fprem         
      fstp c[8]
      finit
    }
    _asm{
      movss xmm1,[two]
      shufps xmm1,xmm1,0x00
      movups xmm0,[c]
      subps xmm0,xmm1
      mulps xmm0,xmm0
      movups [c],xmm0
      fld c
      fadd c[4]
      fadd c[8]
      fsqrt
      fld1
      fsub
      fstp [dist]
    }
    //float dist = sqrt(c[0]+c[1]+c[2])-1.0;    
    dist*=.7f;
    if (dist<.01) 
      break;
    _asm{
      movss xmm3,[dist]
      shufps xmm3,xmm3,0x00
      movups xmm4,[p]
      movups xmm5,[d]
      mulps xmm5,xmm3
      addps xmm4,xmm5
      movups [p],xmm4
    }
  }
  return 15-i;
}

int FXspheres_start = 0;
void FXspheres(TmdcGfx &gfx)
{
  if (FXspheres_start==0) FXspheres_start =clock();
  float t = (clock()-FXspheres_start)*.001;
  for (int y=0; y<200; y+=4)
  for (int x=0; x<320; x+=4)
  {
    float v = spheresf2(x,y,t*t*.313)*.1;
    float r0 = .1;
    float g0 = .6;
    float b0 = -.5+t*.04;
    float r1 = 1.2-t*.04;
    float g1 = .3;
    float b1 = .2+t*.04;
    int r = (r0*y+r1*(200-y))*v; if (r<0) r=0; if (r>255) r=255;
    int g = (g0*y+g1*(200-y))*v; if (g<0) g=0; if (g>255) g=255;
    int b = (b0*y+b1*(200-y))*v; if (b<0) b=0; if (b>255) b=255;
    gfx.SetColor((b<<16)|(g<<8)|b);
    gfx.RectangleFilled(x,y,x+3,y+3);
  }
}

int FXinterference_start = 0;
void FXinterference(TmdcGfx &gfx)
{
  if (FXinterference_start==0) FXinterference_start =clock();
  for (int y=0; y<200; y+=1)
  {
    float t = (clock()-FXinterference_start)*.001;
        
      float s = cos(t*.2)*.5+.5;
    t+= (y&3)*.9*s;
    for (int x=0; x<320; x+=4)
    {
      int noise = rand()%256;        

      float x0 = x-160+sin(t*1.3)*100;
      float y0 = y-100+cos(t*1.4)*100;
      float x1 = x-160+sin(t*1.5)*100;
      float y1 = y-100+cos(t*1.6)*100;

      int dist0 = sqrt(x0*x0+y0*y0)*.03;
      int dist1 = sqrt(x1*x1+y1*y1)*.03;

      int v2 = ((dist0^dist1)&1)*128;

      v2 += noise/(t*.8+.1f);

      int r,g,b; r = g = b = v2;

      gfx.SetColor((b<<16)|(g<<8)|b);
      gfx.RectangleFilled(x,y,x+3,y);
    }
  }
}

int FXcube_start = 0;
void FXcube(TmdcGfx &gfx)
{
  if (FXcube_start == 0) FXcube_start = clock();
  float t = (clock()-FXcube_start) * .001f;

  for (int y=0; y<200; y+=4)
  {
    float distort = y*sin(t)*t*.002;
    float cs1 = cos(t+distort);
    float ss1 = sin(t+distort);
    float cs2 = cos(t*.7+distort*.25);
    float ss2 = sin(t*.7+distort*.25);
    for (int x=0; x<320; x+=4)
    {
      float td[3];
      float d[3];
      float p[3];
      d[0] = x-160;
      d[1] = y-100;
      d[2] = 100;
      float scalar = sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);
      d[0] /= scalar; d[1] /= scalar; d[2] /= scalar;
      p[0]=.0f; p[1]=.0f; p[2]=-4.0f;
      int it;             
        float dist = 0;
      for (it = 0; it < 23; it++)
      {             
        dist = -44;
        float tp[3];
        tp[0] = p[0]*cs1 +         + p[2]*ss1;
        tp[1] =           p[1]   ;        
        tp[2] = p[0]*-ss1 +           p[2]*cs1 ;
        
        float qp[3];
        qp[0] = tp[0];
        qp[1] =         tp[1]*cs2   + tp[2]*ss2;
        qp[2] =         tp[1]*-ss2 + tp[2]*cs2 ;

        for (int i=0; i<3; i++)
        {
          float ndist = abs(qp[i])-1.5f;
          if (dist < ndist) dist = ndist;
        }
        if (dist<.01||dist>7.0) break;

        for (int i=0; i<3; i++)
          p[i] += d[i]*dist;
      }

      if (dist<.1)
      {                                      
        int v = it*(255/23);
        int v2 = v>>1;
        gfx.SetColor(v|(v<<8)|(v<<16));
      }
      else
      {          
        int v = 255-it*(255/20);
        v = v>>2;
        gfx.SetColor((v>>1)|(0<<8)|(v<<16));
      }

      gfx.RectangleFilled(x,y,x+3,y+3);
    }
  }

}

void FXtunnel(TmdcGfx &gfx)
{
  float t = clock()*.001f;
  for (int y=0; y<200; y+=4)
  {
    for (int x=0; x<320; x+=4)
    {
      float xx = x-160.0f;
      float yy = y-100.0f;
      float dir = atan2(xx,yy);
      float dist = 200.0f/sqrt(xx*xx+yy*yy);
      
      int u = (int((dir/3.14159*256)+t*16.0+sin(t*.8)*100.0+sin(t*1.3)*10.0)&255);
      int v = dist*16.0+t*128.0f;
      int r = (u^v)&255;
      int g = r<<1;
      int b = g<<1;
      float qd = 1.0/dist;
      if (qd>1.0) qd=1.0;
      r = r*qd;
      g = g*qd*qd;
      b = b*qd*qd*qd;
      if (r>255) r=255;
      if (g>255) g=255;
      if (b>255) b=255;

      gfx.SetColor(r|(g<<8)|(b<<16));
      gfx.RectangleFilled(x,y,x+3,y+3);
    }
  }
}

void FXzoom(TmdcGfx &gfx)
{
  float t = clock()*.0001f;
 
  float ang = sin(t);
  float cs = cos(t*.9);
  float ss = sin(t*.9);
  float z = sin(t*.2);
 
  
  for (int y=0; y<200; y+=4)
  {
    for (int x=0; x<320; x+=4)
    {
      float xxx = (x-160.0f)*0.01+sin(t*.6)*10.0;
      float yyy = (y-100.0f)*0.01+cos(t*.6)*10.0;
      float xx = xxx*cs+yyy*ss;
      float yy = xxx*-ss+yyy*cs;
      int it;
      for(it=0; it<16; it++)
      {
        if (((int(xx*64.0f))&255)<16 || ((int(yy*64.0f))&255)<16)
          break;
        xx = (xx+yy*ang)*1.1;
        yy = (yy-xx*ang)*1.1;
      }
      
      int r,g,b;
      r=g=b=it*10;
      gfx.SetColor(r|(g<<8)|(b<<16));
      gfx.RectangleFilled(x,y,x+3,y+3);

    }
  }
}


int FXsphere_start = 0;
void FXsphere(TmdcGfx &gfx,bool dark)
{
  if (FXsphere_start == 0) FXsphere_start = clock();
  float t = (clock()-FXsphere_start) * .001f;

  for (int y=0; y<200; y+=4)
  {
    float distort = y*sin(t)*t*.001;
    float cs1 = cos(t+distort);
    float ss1 = sin(t+distort);
    float cs2 = cos(t*.7+distort*.25);
    float ss2 = sin(t*.7+distort*.25);
    for (int x=0; x<320; x+=4)
    {
      float td[3];
      float d[3];
      float p[3];
      d[0] = x-160;
      d[1] = y-100;
      d[2] = 100;
      float scalar = sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);
      d[0] /= scalar; d[1] /= scalar; d[2] /= scalar;
      p[0]=.0f; p[1]=.0f; p[2]=-4.0f;
      int it;             
        
      float dist = 0;
      float qt = .4+t*.05;
      if (qt>4.0) qt = 4.0;
      for (it = 0; it < 40; it++)
      {             
        dist = -44;
        float tp[3];
        tp[0] = p[0]*cs1 +         + p[2]*ss1;
        tp[1] =           p[1]   ;        
        tp[2] = p[0]*-ss1 +           p[2]*cs1 ;
        
        float qp[3];
        qp[0] = tp[0];
        qp[1] =         tp[1]*cs2   + tp[2]*ss2;
        qp[2] =         tp[1]*-ss2 + tp[2]*cs2 ;

        qp[0] += sin(qp[1]*4.0)*qt;
        qp[1] += sin(qp[2]*4.0)*qt;
        qp[2] += sin(qp[0]*4.0)*qt;
        float dist = (sqrt(qp[0]*qp[0]+qp[1]*qp[1]+qp[2]*qp[2])-2.0f)*.2;
        if (dist<.01||dist>7.0) break;

        for (int i=0; i<3; i++)
          p[i] += d[i]*dist;
      }

      if (dist<.1)
      {                                      
        int v = it*(255/40);
        if (dark) v = v>>3;
        int v2 = v>>1;
        gfx.SetColor(v|(v2<<8)|(v2<<16));
      }
      else
      {          
        int v = 255-it*(255/40);
        v = v>>2;
        if (dark) v = v>>3;
        gfx.SetColor((v>>1)|(v<<8)|(v<<16));
      }

      gfx.RectangleFilled(x,y,x+3,y+3);
    }
  }

}