// Vertex shader input structure
struct VS_INPUT
{
    float4 Position   : POSITION;
    float4 Normal     : NORMAL;
    float2 Texture    : TEXCOORD0;
    float4 Tangent    : TANGENT;
    float4 BiTangent  : BINORMAL;
};


// Vertex shader output structure
struct VS_OUTPUT
{
    float4 Position   : POSITION;
    float4 Pos	      : TEXCOORD2;
    float4 MPos       : TEXCOORD5;
};


// Global variables
float4x4 WorldView;
float4x4 Proj;


VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;
    float4 mvPos;                     //create an output vertex

    mvPos = mul(In.Position,
                       WorldView);  //apply vertex transformation

    Out.Position = mul(mvPos, Proj);

    Out.Pos = mvPos;
    Out.MPos = In.Position;
    return Out;                         //return output vertex
}
