#version 410 core


uniform vec2 uResolution;
uniform float uTime;

uniform float uSyncA;
uniform float uSyncB;
uniform float uSyncC;
uniform float uSyncD;

uniform sampler2D uChannelA;
uniform sampler2D uChannelB;
uniform sampler2D uChannelC;
uniform sampler2D uChannelD;

in  vec2    UV;
out vec4    frag_colour;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main () {
    float xoff = uSyncA*.1; // CA
    float yoff = uSyncB;
    
    float r = texture(uChannelA, mod(UV + vec2(xoff, yoff), 1.0) ).r;
    float g = texture(uChannelA, mod(UV + vec2(0, yoff), 1.0) ).g;
    float b = texture(uChannelA, mod(UV + vec2(-xoff, yoff), 1.0) ).b;
    vec3 c = vec3(r,g,b);
    
    c -= pow(length(UV*2.0 - 1.0), 2.5)*.25; // vignette
    c -= (sin(UV.y*uResolution.y)*.5 + .5)*.1; // scanline
    c += rand(UV+sin(uTime)*.1 )*.1;
    
    c += uSyncC;
    
    frag_colour = vec4( c, 1);
}