#Include "fbgfx.bi"

'original code found on http://freebasic.net/forum
type point3d
   x as Single
   y as Single
   z as Single
end type

type point2d
   x as integer
   y as integer
end Type

declare sub sincos_
declare sub rotate_ (ax as integer, ay as integer, az as Integer, p() As point3d, pt() As point3d)
declare sub p2d_ (p() As point3d, p2() As point2d)
declare sub cube_draw_ (c As Integer, p2() As point2d)
Declare Sub cube_fill_ (p() As point3d)


const rad = 0.01224
const vertices = 8 '' cube :)

Dim shared as point3d cube_p(1 to vertices)  '' original vertices
dim shared as point3d cube_pt(1 to vertices) '' transformed vertices
dim shared as point2d cube_p2(1 to vertices) '' 2D vertices

dim shared as integer cube_point_matrix(1 to vertices*3) = {-32,32,32,32,32,32,32,-32,32,-32,-32,32,-32,32,-32,32,32,-32,32,-32,-32,-32,-32,-32}

dim shared as Single sin_lut(0 to 511) '' sine and cosine LUT
dim shared as Single cos_lut(0 to 511) '' for a speedup



'	sincos_
'	fill_
'   
   '' mode 320 x 200, 2 pages, window, no border
'	ScreenRes 640, 480, 8, 2, fb.gfx_high_priority
'	screenset 1, 0 '' set off-screen (2nd page) as target for drawing etc.
'	dim as integer k   
'	Do
'		k = k + 1
'		For i As Integer = 0 To 31
'			'rotate_((k+i)Mod 359, (k+i)Mod 359, (k+i)Mod 359)
'			rotate_((k+i\2)Mod 512, ((k+i\2))Mod 512, ((k+i\2))Mod 512)
'			p2d_
'			draw_ 16+(i\2) '' draw to off-screen
'		Next
'		Sleep 2:screensync '' wait vertical retrace (prevent flicker)
'		flip '' flip off-screen to screen
'		cls '' clear off-screen
'	Loop While InKey = ""
'end



'' sine and cosine look up tables (LUT)
sub sincos_
   dim as integer i
   dim as double r
   for i = 0 to 511
      r = i * rad
      sin_lut(i) = sin(r)
      cos_lut(i) = cos(r)
   next
end sub


'' rotate all vertices
sub rotate_ (ax as integer, ay as integer, az as Integer, p() As point3d, pt() As point3d)
   dim as integer i
   dim as single sinx = sin_lut(ax)
   dim as Single cosx = cos_lut(ax)
   dim as Single siny = sin_lut(ay)
   dim as Single cosy = cos_lut(ay)
   dim as Single sinz = sin_lut(az)
   dim as Single cosz = cos_lut(az)
   dim as Single a, b, c

   for i = 1 to vertices
      pt(i) = p(i)
      
      '' rotate x
      b = pt(i).y
      c = pt(i).z
      pt(i).y = b * cosx - c * sinx
      pt(i).z = b * sinx + c * cosx

      '' rotate y
      a = pt(i).x
      c = pt(i).z
      pt(i).x = a * cosy - c * siny
      pt(i).z = a * siny + c * cosy

      '' rotate z
      a = pt(i).x
      b = pt(i).y
      pt(i).x = a * cosz - b * sinz
      pt(i).y = a * sinz + b * cosz
   next
end sub


'' project 3D -> 2D
sub p2d_ (pt() As point3d, p2() As point2d)
   dim as double zeye = 300
   dim as double t
   dim as integer i

   for i=1 to vertices
      t = zeye / ( zeye - pt(i).z )
      p2(i).x = pt(i).x * t + xcenter
      p2(i).y = pt(i).y * t + ycenter+40
   next
end sub


'' draw (cube this time around)
sub cube_draw_ (c As Integer, p2() As point2d)
   dim as integer i
   for i = 1 to 3
      line (p2(i).x, p2(i).y)-(p2(i+1).x, p2(i+1).y), c
   next
   line (p2(4).x, p2(4).y)-(p2(1).x, p2(1).y), c
   
   for i = 5 to 7
      line (p2(i).x, p2(i).y)-(p2(i+1).x, p2(i+1).y), c
   next
   line (p2(8).x, p2(8).y)-(p2(5).x, p2(5).y), c
   
   line (p2(1).x, p2(1).y)-(p2(5).x, p2(5).y), c
   line (p2(2).x, p2(2).y)-(p2(6).x, p2(6).y), c
   line (p2(3).x, p2(3).y)-(p2(7).x, p2(7).y), c
   line (p2(4).x, p2(4).y)-(p2(8).x, p2(8).y), c
end sub


'' fill in vertices from a point matrix
sub cube_fill_ (p() As point3d)
   dim as integer k = 1
   dim as integer i
   for i = 1 to vertices
      p(i).x = cube_point_matrix(k)  *2
      p(i).y = cube_point_matrix(k+1)*2
      p(i).z = cube_point_matrix(k+2)*2
      k += 3
   next
end sub   